/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Set;
import me.desht.modularrouters.api.matching.IItemMatcher;
import me.desht.modularrouters.api.matching.IModuleFlags;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BulkItemMatcher
implements IItemMatcher {
    private final SetofItemStack stacks;
    private final Set<TagKey<Item>> tags;

    public BulkItemMatcher(SetofItemStack stacks, ModuleFlags flags) {
        this.stacks = stacks;
        this.tags = Sets.newHashSet();
        if (flags.matchItemTags()) {
            ObjectIterator objectIterator = stacks.iterator();
            while (objectIterator.hasNext()) {
                ItemStack stack = (ItemStack)objectIterator.next();
                this.tags.addAll(MiscUtil.itemTags(stack.getItem()));
            }
        }
    }

    @Override
    public boolean matchItem(ItemStack stack, IModuleFlags flags, HolderLookup.Provider registryAccess) {
        if (this.stacks.contains(stack)) {
            return true;
        }
        return flags.matchItemTags() && this.checkForItemTagIntersection(stack);
    }

    private boolean checkForItemTagIntersection(ItemStack stack) {
        return !Sets.intersection(MiscUtil.itemTags(stack.getItem()), this.tags).isEmpty();
    }
}

