/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.ingredient;

import com.blakebr0.ironjetpacks.init.ModDataComponentTypes;
import com.blakebr0.ironjetpacks.init.ModIngredientTypes;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class JetpackComponentIngredient
implements ICustomIngredient {
    public static final MapCodec<JetpackComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("jetpack").forGetter(ingredient -> ingredient.jetpack), (App)ComponentType.CODEC.fieldOf("component").forGetter(ingredient -> ingredient.type)).apply((Applicative)builder, JetpackComponentIngredient::new));
    private final ResourceLocation jetpack;
    private final ComponentType type;
    private ItemStack[] stacks;

    public JetpackComponentIngredient(ResourceLocation jetpack, ComponentType type) {
        this.jetpack = jetpack;
        this.type = type;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        ResourceLocation jetpackID = (ResourceLocation)input.get((DataComponentType)ModDataComponentTypes.JETPACK_ID.get());
        if (jetpackID == null) {
            return false;
        }
        return this.getItems().anyMatch(s -> ItemStack.isSameItem((ItemStack)s, (ItemStack)input) && jetpackID.equals(s.get((DataComponentType)ModDataComponentTypes.JETPACK_ID.get())));
    }

    public Stream<ItemStack> getItems() {
        if (this.stacks == null) {
            ItemStack stack = switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new ItemStack((ItemLike)ModItems.CELL.get());
                case 1 -> new ItemStack((ItemLike)ModItems.THRUSTER.get());
                case 2 -> new ItemStack((ItemLike)ModItems.CAPACITOR.get());
                case 3 -> new ItemStack((ItemLike)ModItems.JETPACK.get());
            };
            stack.set(ModDataComponentTypes.JETPACK_ID, (Object)this.jetpack);
            this.stacks = new ItemStack[]{stack};
        }
        return Stream.of(this.stacks);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.JETPACK_COMPONENT_INGREDIENT.get();
    }

    public static enum ComponentType implements StringRepresentable
    {
        CELL("cell"),
        THRUSTER("thruster"),
        CAPACITOR("capacitor"),
        JETPACK("jetpack");

        public static final Codec<ComponentType> CODEC;
        public final String name;

        private ComponentType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ComponentType::values);
        }
    }
}

