/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.common.components.ElementProtectionFlag;
import alexthw.ars_elemental.common.entity.ai.FollowOwnerGoal;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import com.alexthw.sauce.api.item.ISchoolFocus;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;

@EventBusSubscriber(modid="ars_elemental")
public class Events {
    public static final String TAG_SOULBOUND_DROP_COUNT = "tagSoulboundDC";
    public static final String TAG_SOULBOUND_PREFIX = "tagSoulboundPrefix";
    public static final String TAG_SOULBOUND = "tagSoulbound";

    @SubscribeEvent
    public static void customAI(EntityJoinLevelEvent event) {
        PathfinderMob mob;
        Entity entity;
        if (event.getEntity() instanceof LivingEntity && !event.getLevel().isClientSide && (entity = event.getEntity()) instanceof PathfinderMob && ((mob = (PathfinderMob)entity).getNavigation() instanceof GroundPathNavigation || mob.getNavigation() instanceof FlyingPathNavigation)) {
            try {
                mob.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((Mob)mob, 1.5, 3.0f, 1.2f));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void focusDiscount(SpellCostCalcEvent event) {
        Player player;
        ISchoolFocus focus;
        LivingEntity caster = event.context.getUnwrappedCaster();
        if (!caster.level().isClientSide() && caster instanceof Player && (focus = ISchoolFocus.getFirstFocus((Player)(player = (Player)caster))) != null) {
            if (event.context.getSpell().unsafeList().stream().anyMatch(arg_0 -> ((SpellSchool)focus.getSchool()).isPartOfSchool(arg_0))) {
                event.currentCost = (int)((double)event.currentCost - focus.getDiscount() * (double)event.context.getSpell().getCost());
            }
        }
    }

    @SubscribeEvent
    public static void DeathEvent(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).hasEffect(ModPotions.HYMN_OF_ORDER)) {
            MobEffectInstance effect = player.getEffect(ModPotions.HYMN_OF_ORDER);
            if (effect == null) {
                return;
            }
            CompoundTag data = player.getPersistentData();
            if (!data.contains("PlayerPersisted")) {
                data.put("PlayerPersisted", (Tag)new CompoundTag());
            }
            CompoundTag persist = data.getCompound("PlayerPersisted");
            persist.putBoolean("magic_locked", true);
            persist.putInt("magic_lock_duration", effect.getDuration());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDrop(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.level.holder(ModRegistry.SOULBOUND).isEmpty()) {
                return;
            }
            if (player instanceof FakePlayer || player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
                return;
            }
            Collection drops = event.getDrops();
            ArrayList<ItemEntity> keeps = new ArrayList<ItemEntity>();
            for (ItemEntity item : drops) {
                ItemStack stack = item.getItem();
                if (stack.isEmpty() || stack.getEnchantmentLevel(player.level().holderOrThrow(ModRegistry.SOULBOUND)) <= 0) continue;
                keeps.add(item);
            }
            if (!keeps.isEmpty()) {
                drops.removeAll(keeps);
                CompoundTag cmp = new CompoundTag();
                cmp.putInt(TAG_SOULBOUND_DROP_COUNT, keeps.size());
                int i = 0;
                for (ItemEntity keep : keeps) {
                    ItemStack stack = keep.getItem();
                    Tag cmp1 = stack.saveOptional((HolderLookup.Provider)event.getEntity().registryAccess());
                    cmp.put(TAG_SOULBOUND_PREFIX + i, cmp1);
                    ++i;
                }
                CompoundTag data = player.getPersistentData();
                if (!data.contains("PlayerPersisted")) {
                    data.put("PlayerPersisted", (Tag)new CompoundTag());
                }
                CompoundTag persist = data.getCompound("PlayerPersisted");
                persist.put(TAG_SOULBOUND, (Tag)cmp);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerRespawnHW(PlayerEvent.Clone event) {
        if (!event.isWasDeath() || event.getEntity().level().holder(ModRegistry.SOULBOUND).isEmpty()) {
            return;
        }
        CompoundTag data = event.getEntity().getPersistentData();
        if (data.contains("PlayerPersisted")) {
            CompoundTag persist = data.getCompound("PlayerPersisted");
            if (persist.contains("magic_locked") && persist.contains("magic_lock_duration")) {
                event.getEntity().addEffect(new MobEffectInstance(ModPotions.HYMN_OF_ORDER, persist.getInt("magic_lock_duration")));
                persist.remove("magic_locked");
                persist.remove("magic_lock_duration");
            }
            CompoundTag soulTag = persist.getCompound(TAG_SOULBOUND);
            int count = soulTag.getInt(TAG_SOULBOUND_DROP_COUNT);
            ArrayList<ItemStack> recovered = new ArrayList<ItemStack>();
            for (int i = 0; i < count; ++i) {
                CompoundTag toRecover = soulTag.getCompound(TAG_SOULBOUND_PREFIX + i);
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)event.getEntity().registryAccess(), (CompoundTag)toRecover);
                if (stack.isEmpty()) continue;
                recovered.add(stack.copy());
            }
            for (ItemStack stack : recovered) {
                Item item = stack.getItem();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    if (event.getEntity().getItemBySlot(armor.getType().getSlot()).isEmpty()) {
                        event.getEntity().setItemSlot(armor.getType().getSlot(), stack);
                        continue;
                    }
                }
                if (stack.getItem() instanceof ShieldItem && event.getEntity().getOffhandItem().isEmpty()) {
                    event.getEntity().setItemInHand(InteractionHand.OFF_HAND, stack);
                    continue;
                }
                ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)stack);
            }
            persist.remove(TAG_SOULBOUND);
        }
    }

    @SubscribeEvent
    public static void soulboundCurio(DropRulesEvent event) {
        event.addOverride(i -> {
            Level level = event.getEntity().level;
            return level.holder(ModRegistry.SOULBOUND).isPresent() && i.getEnchantmentLevel(level.holderOrThrow(ModRegistry.SOULBOUND)) > 0;
        }, ICurio.DropRule.ALWAYS_KEEP);
    }

    @SubscribeEvent
    public static void despawnProtection(ItemExpireEvent event) {
        ElementProtectionFlag stackTag = (ElementProtectionFlag)event.getEntity().getItem().get(ModRegistry.P4E);
        if (stackTag != null && stackTag.flag()) {
            event.getEntity().setUnlimitedLifetime();
            event.setExtraLife(0);
        }
    }

    @SubscribeEvent
    public static void flashingForestBreeze(MobSpawnEvent.SpawnPlacementCheck event) {
        BlockPos pos;
        ServerLevelAccessor level;
        if (event.getEntityType() == EntityType.BREEZE && (level = event.getLevel()).getBiome(pos = event.getPos()).is(AETagsProvider.AEBiomeTagsProvider.FLASHING_BIOME) && (pos.getY() < 45 || Monster.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)event.getRandom()) || level.getBlockState(pos.below()).is(Blocks.AIR))) {
            event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
        }
    }
}

