/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.common.glyphs.MethodArcProjectile;
import com.alexthw.sauce.api.IPropagator;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectReset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagatorArc
extends ElementalAbstractEffect
implements IPropagator {
    public static PropagatorArc INSTANCE = new PropagatorArc();

    public AbstractCastMethod getCastType() {
        return MethodArcProjectile.INSTANCE;
    }

    public PropagatorArc() {
        super("propagator_arc", "Propagate Arc");
        EffectReset.RESET_LIMITS.add(this);
    }

    public String getBookDescription() {
        return "Convert the remainder of the spell into an Arc Projectile and shoot it from where it lands.";
    }

    public Integer getTypeIndex() {
        return 8;
    }

    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        Vec3 pos = hitResult.getLocation();
        ArrayList<EntityProjectileSpell> projectiles = new ArrayList<EntityProjectileSpell>();
        EntityProjectileSpell projectileSpell = new EntityProjectileSpell(world, resolver).setGravity(true);
        projectileSpell.setPos(pos.add(0.0, 1.0, 0.0));
        projectiles.add(projectileSpell);
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        float sizeRatio = shooter.getEyeHeight() / 1.62f;
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.getDirection().getClockWise();
            if (i % 2 == 0) {
                offset = offset.getOpposite();
            }
            BlockPos projPos = BlockPos.containing((Position)pos).relative(offset, i).offset(0, (int)(1.5 * (double)sizeRatio), 0);
            EntityProjectileSpell spell = new EntityProjectileSpell(world, resolver).setGravity(true);
            spell.setPos((double)projPos.getX(), (double)projPos.getY(), (double)projPos.getZ());
            projectiles.add(spell);
        }
        float velocity = MethodArcProjectile.getProjectileSpeed(stats);
        Vec3 direction = IPropagator.getDirection((LivingEntity)shooter, (SpellResolver)resolver, (Vec3)pos);
        for (EntityProjectileSpell proj : projectiles) {
            proj.setPos(proj.position().add(0.0, 0.25 * (double)sizeRatio, 0.0));
            if (stats.hasBuff((AbstractAugment)AugmentExtract.INSTANCE) || shooter instanceof FakePlayer) {
                proj.shoot(direction.x, direction.y, direction.z, velocity, 0.8f);
            } else {
                proj.shoot((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, velocity, 0.3f);
            }
            world.addFreshEntity((Entity)proj);
        }
    }

    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 150;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        HashSet<AbstractAugment> extended = new HashSet<AbstractAugment>(MethodArcProjectile.INSTANCE.getCompatibleAugments());
        extended.add((AbstractAugment)AugmentExtract.INSTANCE);
        return extended;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentPierce.INSTANCE, "Projectiles will bounce on blocks or hit through enemies an additional time.");
        map.put((AbstractAugment)AugmentSplit.INSTANCE, "Creates multiple projectiles.");
        map.put((AbstractAugment)AugmentAccelerate.INSTANCE, "Projectiles will move faster.");
        map.put((AbstractAugment)AugmentDecelerate.INSTANCE, "Projectiles will move slower.");
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Projectiles will hit plants and other materials that do not block motion.");
        map.put((AbstractAugment)AugmentExtract.INSTANCE, "Projectile direction will be relative to caster position.");
    }
}

