/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.plugin;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.impl.TempResourceManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;

public class KJSTPluginUtils {
    public static WeakReference<CloseableResourceManager> SERVER_PACK_RESOURCES = new WeakReference<Object>(null);
    public static CloseableResourceManager CLIENT_PACK_RESOURCES;
    public static CloseableResourceManager TEMPORARY_SERVER_PACK_RESOURCES;

    @Nullable
    public static JsonElement readJsonFromMod(Context cx, String modId, String id) {
        KJSTPackType type = ((KubeJSContext)cx).getType().equals((Object)ScriptType.CLIENT) ? KJSTPackType.ASSETS : KJSTPackType.DATA;
        return KJSTPluginUtils.readJsonFromMod(cx, modId, id, type);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static JsonElement readJsonFromMod(Context cx, String modId, String id, KJSTPackType type) {
        ResourceLocation rl;
        block11: {
            rl = KJSTPluginUtils.toJsonRL(cx, id, (String)modId);
            Object object = modId = ((String)modId).equals("minecraft") ? "vanilla" : "mod/" + (String)modId;
            if (type == KJSTPackType.ASSETS) {
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    if (Minecraft.getInstance().getResourceManager().getNamespaces().isEmpty()) {
                        CloseableResourceManager rm = CLIENT_PACK_RESOURCES;
                        if (rm != null) {
                            List resources = rm.getResourceStack(rl);
                            ScriptType kjsSide = ((KubeJSContext)cx).getType();
                            if (!kjsSide.equals((Object)ScriptType.CLIENT)) {
                                ConsoleJS.getCurrent((Context)cx).warn((Object)("You are querying the assets of " + (String)modId + " from " + String.valueOf(kjsSide) + ", remember that this is not supported on a DEDICATED SERVER."));
                            }
                            return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
                        }
                        break block11;
                    } else {
                        if (CLIENT_PACK_RESOURCES != null) {
                            CLIENT_PACK_RESOURCES = null;
                        }
                        List resources = Minecraft.getInstance().getResourceManager().getResourceStack(rl);
                        ScriptType kjsSide = ((KubeJSContext)cx).getType();
                        if (!kjsSide.equals((Object)ScriptType.CLIENT)) {
                            ConsoleJS.getCurrent((Context)cx).warn((Object)("You are querying the assets of " + (String)modId + " from " + String.valueOf(kjsSide) + ", remember that this is not supported on a DEDICATED SERVER."));
                        }
                        return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
                    }
                }
                ConsoleJS.getCurrent((Context)cx).error((Object)("Failed to get json with id " + String.valueOf(rl) + ", not possible to get assets from dedicated server."));
            }
        }
        if (type == KJSTPackType.DATA) {
            ResourceManager rm;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                List resources = server.getResourceManager().getResourceStack(rl);
                return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
            }
            ResourceManager resourceManager = rm = SERVER_PACK_RESOURCES.get() == null ? KJSTPluginUtils.loadTemporaryServerPackResources() : (ResourceManager)SERVER_PACK_RESOURCES.get();
            if (rm != null) {
                List resources = rm.getResourceStack(rl);
                return KJSTPluginUtils.readJsonFromResourceList(cx, (String)modId, resources, rl);
            }
            ConsoleJS.getCurrent((Context)cx).error((Object)("Failed to get json with id " + String.valueOf(rl) + ", not ready yet."));
        }
        return JsonNull.INSTANCE;
    }

    private static ResourceManager loadTemporaryServerPackResources() {
        if (TEMPORARY_SERVER_PACK_RESOURCES != null) {
            return TEMPORARY_SERVER_PACK_RESOURCES;
        }
        HashMap map = Maps.newHashMap();
        RepositorySource source = ResourcePackLoader.buildPackFinder((Map)map, (PackType)PackType.SERVER_DATA);
        PackRepository packRepo = new PackRepository(new RepositorySource[]{source});
        ResourcePackLoader.populatePackRepository((PackRepository)packRepo, (PackType)PackType.SERVER_DATA, (boolean)false);
        packRepo.reload();
        ServerPacksSource vanillaPack = new ServerPacksSource(new DirectoryValidator(path -> true));
        ArrayList<PackResources> packs = new ArrayList<PackResources>(packRepo.openAllSelected());
        packs.addFirst((PackResources)vanillaPack.getVanillaPack());
        TEMPORARY_SERVER_PACK_RESOURCES = new TempResourceManager(PackType.SERVER_DATA, packs);
        return TEMPORARY_SERVER_PACK_RESOURCES;
    }

    private static JsonElement readJsonFromResourceList(Context cx, String modId, List<Resource> resources, ResourceLocation id) {
        ArrayList<String> modsFound = new ArrayList<String>();
        Resource found = null;
        for (Resource resource : resources) {
            modsFound.add(resource.sourcePackId());
            if (found != null) continue;
            found = resource.sourcePackId().equals(modId) ? resource : null;
        }
        if (found != null) {
            JsonElement jsonElement;
            block11: {
                InputStream reader = found.open();
                try {
                    if (modsFound.size() > 1) {
                        ConsoleJS.getCurrent((Context)cx).warn((Object)("Multiple mods (" + String.valueOf(modsFound) + ") found for resource " + String.valueOf(id) + ", using " + found.sourcePackId()));
                    }
                    jsonElement = JsonIO.parseRaw((String)new String(reader.readAllBytes()));
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ConsoleJS.getCurrent((Context)cx).error("Not possible to read json", (Throwable)e);
                    }
                }
                reader.close();
            }
            return jsonElement;
        }
        ConsoleJS.getCurrent((Context)cx).error((Object)("Not possible to read json with id " + String.valueOf(id) + ", resource not found."));
        return JsonNull.INSTANCE;
    }

    private static ResourceLocation toJsonRL(Context cx, String id, String modId) {
        String extension = ((String)id).substring(((String)id).lastIndexOf(46) + 1);
        if (extension.equals("json")) {
            return ((String)id).indexOf(58) >= 0 ? ResourceLocation.parse((String)id) : ResourceLocation.fromNamespaceAndPath((String)modId, (String)id);
        }
        if (extension.equals(id)) {
            return ((String)(id = (String)id + ".json")).indexOf(58) >= 0 ? ResourceLocation.parse((String)id) : ResourceLocation.fromNamespaceAndPath((String)modId, (String)id);
        }
        throw new KubeRuntimeException("Error while reading file.", (Throwable)new UnsupportedOperationException("Failed to read json with id " + (String)id + ", extension " + extension + " is invalid, only json is supported")).source(SourceLine.of((Context)cx));
    }

    public static Class<?> getClass(Object obj) {
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            return clazz;
        }
        return obj.getClass();
    }

    public static Class<?> getSuperclass(Object object) {
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return clazz.getSuperclass();
        }
        if (object instanceof NativeJavaObject) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)object;
            return nativeJavaObject.unwrap().getClass().getSuperclass();
        }
        throw new IllegalStateException("Failed to get superclass of " + String.valueOf(object));
    }

    public static void runIfModPresent(Context cx, String modId, String versionRange, Callable<Void> runnable) {
        IModFileInfo modFile = ModList.get().getModFileById(modId);
        if (modFile == null) {
            ConsoleJS.getCurrent((Context)cx).debug((Object)("Mod " + modId + " not loaded, skipping task."));
            return;
        }
        if (versionRange == null) {
            versionRange = "*";
        }
        String modVersionString = modFile.versionString();
        DefaultArtifactVersion modVersion = new DefaultArtifactVersion(modVersionString);
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionRange);
            if (range.containsVersion((ArtifactVersion)modVersion)) {
                runnable.call();
            } else {
                ConsoleJS.getCurrent((Context)cx).debug((Object)("Mod " + modId + " with version range " + versionRange + " not loaded, skipping task."));
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new KubeRuntimeException("Error while parsing range version", (Throwable)e).source(SourceLine.of((Context)cx));
        }
        catch (Exception e) {
            throw new KubeRuntimeException("Error while executing task", (Throwable)e).source(SourceLine.of((Context)cx));
        }
    }

    public static void runIfModPresent(Context cx, String modId, Callable<Void> runnable) {
        KJSTPluginUtils.runIfModPresent(cx, modId, "*", runnable);
    }

    public static void curseForgeGetEndpoint(String url, Executor executor, Consumer<JsonElement> callback) {
        CompletableFuture.runAsync(() -> {
            block15: {
                HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(15L)).build();
                StringBuilder sb = new StringBuilder();
                sb.append("Java-http-client/").append(System.getProperty("java.version")).append(' ');
                sb.append("KubeJSTweaks/").append(LoadingModList.get().getModFileById("kubejstweaks").versionString());
                String userAgent = sb.toString();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://www.curseforge.com/api/" + url)).timeout(Duration.ofSeconds(15L)).setHeader("Accept-Encoding", "gzip").setHeader("User-Agent", userAgent).GET().build();
                try {
                    HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                    int responseCode = response.statusCode();
                    if (responseCode == 200) {
                        String bodyStr;
                        boolean isGzipEncoded = response.headers().firstValue("Content-Encoding").orElse("").equals("gzip");
                        try (InputStream inStream = isGzipEncoded ? new GZIPInputStream(response.body()) : response.body();
                             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inStream));){
                            bodyStr = bufferedReader.lines().collect(Collectors.joining("\n"));
                        }
                        executor.execute(() -> {
                            try {
                                callback.accept(JsonUtils.fromString((String)bodyStr));
                            }
                            catch (Exception e) {
                                KubeJSTweaks.LOGGER.error("Error while executing from CF Endpoint callback", (Throwable)e);
                            }
                        });
                        break block15;
                    }
                    KubeJSTweaks.LOGGER.error("Error while trying to call CF endpoint {}, response code: {}", (Object)url, (Object)responseCode);
                    KubeJSTweaks.LOGGER.warn("You are only allowed to call public endpoints (does not require API-KEY)");
                }
                catch (IOException | InterruptedException e) {
                    KubeJSTweaks.LOGGER.error("Error while trying to call CF endpoint {}, error: {}", (Object)url, (Object)e.getMessage());
                    if (!(e instanceof InterruptedException)) break block15;
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    static {
        TEMPORARY_SERVER_PACK_RESOURCES = null;
    }

    public static enum KJSTPackType {
        ASSETS(PackType.CLIENT_RESOURCES),
        DATA(PackType.SERVER_DATA);

        private final PackType packType;

        private KJSTPackType(PackType packType) {
            this.packType = packType;
        }
    }
}

