/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks;

import dev.uncandango.kubejstweaks.Config;
import dev.uncandango.kubejstweaks.kubejs.schema.CodecParsedListener;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.throwables.ClassAlreadyLoadedException;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.perf.Profiler;

@Mod(value="kubejstweaks")
public class KubeJSTweaks {
    public static final String MODID = "kubejstweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"KubeJS Tweaks");
    private static IEventBus MOD_EVENT_BUS;
    private static final Path LOCAL;

    public KubeJSTweaks(IEventBus modEventBus, ModContainer modContainer) {
        MOD_EVENT_BUS = modEventBus;
        modEventBus.addListener(this::loadCompleteSetup);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static Path getLocal() {
        return LOCAL;
    }

    private void loadCompleteSetup(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            try {
                Class<?> clazz = Class.forName("com.mojang.serialization.Decoder$CodecParsedEvent");
                MOD_EVENT_BUS.addListener(clazz, CodecParsedListener::codecParsed);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to listen to event of codec parsed", (Throwable)e);
            }
        });
        if (!FMLEnvironment.production) {
            event.enqueueWork(KubeJSTweaks::auditMyMixinsOnly);
        }
    }

    private static void auditMyMixinsOnly() {
        try {
            ClassAlreadyLoadedException ex;
            Class<ModFileParser.MixinConfig> MIXIN_CONFIG_CLASS = ModFileParser.MixinConfig.class;
            MethodHandle unhandledMixinsMH = MethodHandles.lookup().unreflect(ObfuscationReflectionHelper.findMethod(MIXIN_CONFIG_CLASS, (String)"getUnhandledTargets", (Class[])new Class[]{Set.class}));
            org.spongepowered.asm.mixin.transformer.Config configMain = org.spongepowered.asm.mixin.transformer.Config.create((String)"kubejstweaks.mixins.json", (MixinEnvironment)MixinEnvironment.getCurrentEnvironment(), null);
            boolean kjs72Loaded = LoadingModList.get().getModFileById("kubejs").versionString().startsWith("2101.7.2-");
            org.spongepowered.asm.mixin.transformer.Config configSpecific = kjs72Loaded ? org.spongepowered.asm.mixin.transformer.Config.create((String)"kubejstweaks-kjs72.mixins.json", (MixinEnvironment)MixinEnvironment.getCurrentEnvironment(), null) : org.spongepowered.asm.mixin.transformer.Config.create((String)"kubejstweaks-kjs71.mixins.json", (MixinEnvironment)MixinEnvironment.getCurrentEnvironment(), null);
            Set unhandled = unhandledMixinsMH.invoke(configMain.getConfig());
            unhandled.addAll(unhandledMixinsMH.invoke(configSpecific.getConfig()));
            HashSet unhandledCopy = new HashSet(unhandled);
            ILogger auditLogger = MixinService.getService().getLogger("mixin.audit");
            for (String target : unhandledCopy) {
                try {
                    auditLogger.info("Force-loading class {}", new Object[]{target});
                    MixinService.getService().getClassProvider().findClass(target, true);
                }
                catch (ClassNotFoundException ex2) {
                    auditLogger.error("Could not force-load " + target, (Throwable)ex2);
                }
            }
            for (String target : unhandledMixinsMH.invoke(configMain.getConfig())) {
                ex = new ClassAlreadyLoadedException(target + " was already classloaded");
                auditLogger.error("Could not force-load " + target, (Throwable)ex);
            }
            for (String target : unhandledMixinsMH.invoke(configSpecific.getConfig())) {
                ex = new ClassAlreadyLoadedException(target + " was already classloaded");
                auditLogger.error("Could not force-load " + target, (Throwable)ex);
            }
            if (MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_PROFILER)) {
                Profiler.printAuditSummary();
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while auditing mixins", e);
        }
    }

    static {
        LOCAL = FMLPaths.GAMEDIR.get().resolve("local").resolve(MODID);
    }
}

