/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.semiblock.SemiblockAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.jetbrains.annotations.Nullable;

public enum SemiblockTracker implements SemiblockAccess
{
    INSTANCE;

    private final Map<ResourceLocation, Map<BlockPos, SemiblockCollection>> semiblockMap = new HashMap<ResourceLocation, Map<BlockPos, SemiblockCollection>>();

    public static SemiblockTracker getInstance() {
        return INSTANCE;
    }

    @Override
    public ISemiBlock getSemiblock(Level level, BlockPos pos) {
        return this.getSemiblock(level, pos, null);
    }

    @Override
    public ISemiBlock getSemiblock(Level level, BlockPos pos, Direction direction) {
        if (!level.isLoaded(pos)) {
            return null;
        }
        Map<BlockPos, SemiblockCollection> map = this.semiblockMap.get(this.getKey(level));
        if (map == null) {
            return null;
        }
        SemiblockCollection sc = map.get(pos);
        return sc == null ? null : sc.get(level, direction);
    }

    @Override
    public Stream<ISemiBlock> getAllSemiblocks(Level world, BlockPos pos) {
        return this.getAllSemiblocks(world, pos, null);
    }

    @Override
    public Stream<ISemiBlock> getAllSemiblocks(Level level, BlockPos pos, Direction offsetDir) {
        if (!level.isLoaded(pos)) {
            return Stream.empty();
        }
        Map map = this.semiblockMap.computeIfAbsent(this.getKey(level), k -> new HashMap());
        if (map.isEmpty()) {
            return Stream.empty();
        }
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null && offsetDir != null) {
            sc = (SemiblockCollection)map.get(pos.relative(offsetDir));
        }
        return sc == null ? Stream.empty() : sc.getAll(level);
    }

    public void clearSemiblock(Level level, BlockPos pos, Direction direction) {
        Map map = this.semiblockMap.computeIfAbsent(this.getKey(level), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc != null) {
            sc.clear(direction);
            if (sc.isEmpty()) {
                map.remove(pos);
            }
        }
    }

    public void putSemiblock(Level level, BlockPos pos, ISemiBlock entity) {
        Map map = this.semiblockMap.computeIfAbsent(this.getKey(level), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null) {
            map.put(pos, new SemiblockCollection(entity));
        } else {
            sc.set(entity);
        }
    }

    public Stream<ISemiBlock> getSemiblocksInArea(Level level, BoundingBox aabb) {
        Map map = this.semiblockMap.computeIfAbsent(this.getKey(level), k -> new HashMap());
        return map.entrySet().stream().filter(e -> this.boxContainsBlockPos(aabb, (BlockPos)e.getKey())).flatMap(e -> ((SemiblockCollection)e.getValue()).getAll(level));
    }

    private boolean boxContainsBlockPos(BoundingBox aabb, BlockPos pos) {
        return pos.getX() >= aabb.minX() && pos.getX() <= aabb.maxX() && pos.getY() >= aabb.minY() && pos.getY() <= aabb.maxY() && pos.getZ() >= aabb.minZ() && pos.getZ() <= aabb.maxZ();
    }

    private ResourceLocation getKey(Level world) {
        return world.dimension().location();
    }

    private static class SemiblockCollection {
        private final Map<CenterDirection, Integer> sides = new EnumMap<CenterDirection, Integer>(CenterDirection.class);

        SemiblockCollection(ISemiBlock e) {
            this.set(e);
        }

        boolean isEmpty() {
            return this.sides.isEmpty();
        }

        ISemiBlock get(Level level, Direction dir) {
            return this.getValidSemiblock(level, CenterDirection.of(dir));
        }

        void set(ISemiBlock semiBlock) {
            CenterDirection cDir = CenterDirection.of(IDirectionalSemiblock.getDirection(semiBlock));
            this.sides.put(cDir, semiBlock.getTrackingId());
        }

        void clear(Direction direction) {
            this.sides.remove((Object)CenterDirection.of(direction));
        }

        Stream<ISemiBlock> getAll(Level level) {
            return Arrays.stream(CenterDirection.values()).map(d -> this.getValidSemiblock(level, (CenterDirection)((Object)d))).filter(Objects::nonNull);
        }

        ISemiBlock getValidSemiblock(Level level, CenterDirection cDir) {
            int id = this.sides.getOrDefault((Object)cDir, 0);
            if (id != 0) {
                ISemiBlock semiBlock;
                Entity entity = level.getEntity(id);
                if (entity instanceof ISemiBlock && (semiBlock = (ISemiBlock)entity).isValid()) {
                    return semiBlock;
                }
                this.sides.remove((Object)cDir);
            }
            return null;
        }
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onServerStopping(ServerStoppingEvent event) {
            if (!event.getServer().isDedicatedServer()) {
                SemiblockTracker.getInstance().semiblockMap.values().forEach(Map::clear);
                SemiblockTracker.getInstance().semiblockMap.clear();
            }
        }
    }

    private static enum CenterDirection {
        CENTER,
        DOWN,
        UP,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public static CenterDirection of(@Nullable Direction dir) {
            if (dir == null) {
                return CENTER;
            }
            return switch (dir) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> DOWN;
                case Direction.UP -> UP;
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
            };
        }
    }
}

