/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.remote;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.remote.IRemoteWidget;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;

public class SavedRemoteLayout {
    public static final int JSON_VERSION = 2;
    public static final Codec<SavedRemoteLayout> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IRemoteWidget.CODEC.listOf().fieldOf("widgets").forGetter(s -> s.widgets)).apply((Applicative)builder, SavedRemoteLayout::new));
    public static final Codec<Versioned> VERSIONED_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("version").forGetter(Versioned::version), (App)IRemoteWidget.CODEC.listOf().fieldOf("widgets").forGetter(Versioned::widgets)).apply((Applicative)builder, Versioned::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SavedRemoteLayout> STREAM_CODEC = StreamCodec.composite((StreamCodec)IRemoteWidget.STREAM_CODEC.apply(ByteBufCodecs.list()), s -> s.widgets, SavedRemoteLayout::new);
    public static final SavedRemoteLayout EMPTY = new SavedRemoteLayout(List.of());
    private final List<IRemoteWidget> widgets;

    public SavedRemoteLayout(Collection<IRemoteWidget> widgets) {
        this.widgets = List.copyOf(widgets);
    }

    public static SavedRemoteLayout fromJson(HolderLookup.Provider provider, JsonElement json) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        return VERSIONED_CODEC.parse((DynamicOps)ops, (Object)json).resultOrPartial(err -> Log.warning("can't parse remote layout JSON: " + err, new Object[0])).map(v -> new SavedRemoteLayout(v.widgets())).orElse(EMPTY);
    }

    public JsonElement toJson(HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        Versioned saved = new Versioned(2, this.widgets);
        return (JsonElement)VERSIONED_CODEC.encodeStart((DynamicOps)ops, (Object)saved).result().orElseThrow();
    }

    public static SavedRemoteLayout fromItem(ItemStack stack) {
        return (SavedRemoteLayout)stack.getOrDefault(ModDataComponents.REMOTE_LAYOUT, (Object)EMPTY);
    }

    public List<IRemoteWidget> getWidgets() {
        return this.widgets;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SavedRemoteLayout that = (SavedRemoteLayout)obj;
        return Objects.equals(this.widgets, that.widgets);
    }

    public int hashCode() {
        return Objects.hash(this.widgets);
    }

    public String toString() {
        return "Saved[widgets=" + String.valueOf(this.widgets) + "]";
    }

    public record Versioned(int version, List<IRemoteWidget> widgets) {
    }
}

