/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.gui.ClassifyFilterScreen;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;

public class ClassifyFilterItem
extends Item
implements IFilteringItem {
    public ClassifyFilterItem() {
        super(ModItems.defaultProps().component(ModDataComponents.CLASSIFY_FILTER_SETTINGS, (Object)FilterSettings.NONE));
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide) {
            ClassifyFilterScreen.openGui(stack.getHoverName(), pUsedHand);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public boolean matchFilter(ItemStack filterStack, ItemStack stack) {
        Validate.isTrue((boolean)(filterStack.getItem() instanceof ClassifyFilterItem), (String)"filter item stack is not a Classify Filter!", (Object[])new Object[0]);
        return FilterSettings.fromStack(filterStack).test(stack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
        FilterSettings settings = FilterSettings.fromStack(pStack);
        pTooltipComponents.add((Component)ClassifyFilterItem.xlateMatch(settings.matchAll()).withStyle(ChatFormatting.YELLOW));
        for (FilterCondition c : settings.filterConditions()) {
            pTooltipComponents.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate(c.getTranslationKey(), new Object[0])).withStyle(ChatFormatting.GOLD));
        }
    }

    private static boolean isCookable(RecipeType<? extends AbstractCookingRecipe> type, ItemStack stack) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().overworld();
        if (level == null) {
            return false;
        }
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return level.getRecipeManager().getRecipeFor(type, (RecipeInput)input, (Level)level).isPresent();
    }

    public static MutableComponent xlateMatch(boolean matchAll) {
        return PneumaticCraftUtils.xlate(matchAll ? "pneumaticcraft.gui.tooltip.filter.matchAll" : "pneumaticcraft.gui.tooltip.filter.matchAny", new Object[0]);
    }

    public record FilterSettings(boolean matchAll, List<FilterCondition> filterConditions) implements Predicate<ItemStack>
    {
        public static final FilterSettings NONE = new FilterSettings(false, Collections.emptyList());
        public static final Codec<FilterSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("match_all", (Object)false).forGetter(FilterSettings::matchAll), (App)StringRepresentable.fromEnum(FilterCondition::values).listOf().fieldOf("conditions").forGetter(FilterSettings::filterConditions)).apply((Applicative)builder, FilterSettings::new));
        public static final StreamCodec<FriendlyByteBuf, FilterSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, FilterSettings::matchAll, (StreamCodec)NeoForgeStreamCodecs.enumCodec(FilterCondition.class).apply(ByteBufCodecs.list()), FilterSettings::filterConditions, FilterSettings::new);

        public static FilterSettings fromStack(ItemStack filterStack) {
            return (FilterSettings)filterStack.getOrDefault(ModDataComponents.CLASSIFY_FILTER_SETTINGS, (Object)NONE);
        }

        public void save(ItemStack stack) {
            stack.set(ModDataComponents.CLASSIFY_FILTER_SETTINGS, (Object)this);
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.matchAll ? this.filterConditions.stream().allMatch(c -> c.test(stack)) : this.filterConditions.stream().anyMatch(c -> c.test(stack));
        }
    }

    public static enum FilterCondition implements ITranslatableEnum,
    Predicate<ItemStack>,
    StringRepresentable
    {
        FUEL_ITEM((ItemLike)Items.COAL, s -> s.getBurnTime(RecipeType.SMELTING) > 0),
        EDIBLE((ItemLike)Items.BREAD, s -> PneumaticCraftUtils.getOptionalComponent(s, DataComponents.FOOD).map(f -> f.nutrition() > 0).orElse(false)),
        PLACEABLE((ItemLike)Items.STONE, s -> s.getItem() instanceof BlockItem),
        FLUID_CONTAINER((ItemLike)Items.BUCKET, s -> IOHelper.getFluidHandlerForItem(s).isPresent()),
        UNSTACKABLE((ItemLike)Items.WRITABLE_BOOK, s -> s.getMaxStackSize() == 1),
        WEARABLE((ItemLike)Items.LEATHER_HELMET, s -> s.getItem() instanceof ArmorItem),
        TOOL((ItemLike)Items.IRON_PICKAXE, s -> s.getItem() instanceof TieredItem),
        WEAPON((ItemLike)Items.IRON_SWORD, s -> s.getItem() instanceof SwordItem || s.getItem() instanceof AxeItem || s.getItem() instanceof ProjectileWeaponItem),
        ENCHANTABLE((ItemLike)Items.BOOK, s -> s.isEnchantable() && !s.isEnchanted()),
        ENCHANTED((ItemLike)Items.ENCHANTED_BOOK, ItemStack::isEnchanted),
        SMELTABLE((ItemLike)Blocks.FURNACE, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.SMELTING, s)),
        BLASTABLE((ItemLike)Blocks.BLAST_FURNACE, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.BLASTING, s)),
        SMOKABLE((ItemLike)Blocks.SMOKER, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.SMOKING, s)),
        CAMPFIRE_COOKABLE((ItemLike)Blocks.CAMPFIRE, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.CAMPFIRE_COOKING, s));

        private final ItemStack icon;
        private final Predicate<ItemStack> predicate;

        private FilterCondition(ItemLike icon, Predicate<ItemStack> predicate) {
            this.icon = new ItemStack(icon);
            this.predicate = predicate;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.predicate.test(stack);
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tooltip.filter." + this.toString().toLowerCase(Locale.ROOT);
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

