/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIPlace;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetPlace
extends ProgWidgetDigAndPlace {
    public static final MapCodec<ProgWidgetPlace> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetPlace.digPlaceParts(builder).and((App)Codec.BOOL.optionalFieldOf("randomize", (Object)false).forGetter(ProgWidgetPlace::isRandomize)).apply((Applicative)builder, ProgWidgetPlace::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetPlace> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDigAndPlace.DigPlaceFields.STREAM_CODEC, p -> p.digPlaceFields, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetPlace::isRandomize, ProgWidgetPlace::new);
    private boolean randomize;

    public ProgWidgetPlace(ProgWidget.PositionFields pos, ProgWidgetDigAndPlace.DigPlaceFields digPlaceFields, boolean randomize) {
        super(pos, digPlaceFields);
        this.randomize = randomize;
    }

    public ProgWidgetPlace() {
        super(ProgWidget.PositionFields.DEFAULT, ProgWidgetDigAndPlace.DigPlaceFields.makeDefault(IBlockOrdered.Ordering.LOW_TO_HIGH));
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetPlace(this.getPosition(), this.digPlaceFields, this.randomize);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_PLACE;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.PLACE.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIPlace<ProgWidgetAreaItemBase>(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }
}

