/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.goal.Goal;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public abstract class ProgWidgetDroneCondition
extends ProgWidgetConditionBase
implements ICondition,
IVariableSetWidget {
    protected DroneConditionFields cond;

    protected static <P extends ProgWidgetDroneCondition> Products.P2<RecordCodecBuilder.Mu<P>, ProgWidget.PositionFields, DroneConditionFields> droneConditionParts(RecordCodecBuilder.Instance<P> pInstance) {
        return ProgWidgetDroneCondition.baseParts(pInstance).and((App)DroneConditionFields.CODEC.fieldOf("drone_cond").forGetter(p -> p.cond));
    }

    public ProgWidgetDroneCondition() {
        this(ProgWidget.PositionFields.DEFAULT, DroneConditionFields.DEFAULT);
    }

    public ProgWidgetDroneCondition(ProgWidget.PositionFields pos, DroneConditionFields cond) {
        super(pos);
        this.cond = cond;
    }

    @Override
    public boolean evaluate(IDrone drone, IProgWidget widget) {
        return this.getOperator().evaluate(this.getCount(drone, widget), this.getRequiredCount());
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.getMeasureVar().isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.measure", new Object[0]).append(this.getMeasureVar()));
        }
    }

    protected abstract int getCount(IDrone var1, IProgWidget var2);

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        if (widget instanceof ProgWidgetDroneCondition) {
            return null;
        }
        return new Goal(this){

            public boolean canUse() {
                return false;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean baseEquals(ProgWidget other) {
        if (!super.baseEquals(other)) return false;
        if (!(other instanceof ProgWidgetDroneCondition)) return false;
        ProgWidgetDroneCondition c = (ProgWidgetDroneCondition)other;
        if (!this.cond.equals(c.cond)) return false;
        return true;
    }

    @Override
    protected int baseHashCode() {
        return Objects.hash(this.positionFields, this.cond);
    }

    @Override
    public boolean isAndFunction() {
        return this.cond.isAndFunc;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.cond = this.cond.withIsAndFunc(isAndFunction);
    }

    @Override
    public int getRequiredCount() {
        return this.cond.requiredCount;
    }

    @Override
    public void setRequiredCount(int count) {
        this.cond = this.cond.withRequiredCount(count);
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.cond.op;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.cond = this.cond.withOp(operator);
    }

    @Override
    public String getMeasureVar() {
        return this.cond.measureVar;
    }

    @Override
    public void setMeasureVar(String measureVar) {
        this.cond = this.cond.withMeasureVar(measureVar);
    }

    @Override
    public List<Component> getExtraStringInfo() {
        MutableComponent anyAll = PneumaticCraftUtils.xlate(this.isAndFunction() ? "pneumaticcraft.gui.misc.all" : "pneumaticcraft.gui.misc.any", new Object[0]).append(" " + this.getOperator().toString() + " " + this.getRequiredCount());
        return this.getMeasureVar().isEmpty() ? Collections.singletonList(anyAll) : ImmutableList.of((Object)anyAll, (Object)this.varAsTextComponent(this.getMeasureVar()));
    }

    @Override
    public void addVariables(Set<String> variables) {
        if (!this.getMeasureVar().isEmpty()) {
            variables.add(this.getMeasureVar());
        }
    }

    @Override
    public String getVariable() {
        return this.getMeasureVar();
    }

    @Override
    public void setVariable(String variable) {
        this.setMeasureVar(variable);
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
    }

    public DroneConditionFields droneConditionFields() {
        return this.cond;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetDroneCondition that = (ProgWidgetDroneCondition)o;
        return this.baseEquals(that) && Objects.equals(this.cond, that.cond);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.positionFields, this.cond);
    }

    public record DroneConditionFields(boolean isAndFunc, ICondition.Operator op, int requiredCount, String measureVar) {
        public static final DroneConditionFields DEFAULT = new DroneConditionFields(false, ICondition.Operator.GE, 1, "");
        public static final Codec<DroneConditionFields> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("and_func", (Object)false).forGetter(DroneConditionFields::isAndFunc), (App)StringRepresentable.fromEnum(ICondition.Operator::values).optionalFieldOf("cond_op", (Object)ICondition.Operator.GE).forGetter(DroneConditionFields::op), (App)Codec.INT.optionalFieldOf("required_count", (Object)1).forGetter(DroneConditionFields::requiredCount), (App)Codec.STRING.optionalFieldOf("measure_var", (Object)"").forGetter(DroneConditionFields::measureVar)).apply((Applicative)builder, DroneConditionFields::new));
        public static final StreamCodec<FriendlyByteBuf, DroneConditionFields> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, DroneConditionFields::isAndFunc, (StreamCodec)NeoForgeStreamCodecs.enumCodec(ICondition.Operator.class), DroneConditionFields::op, (StreamCodec)ByteBufCodecs.VAR_INT, DroneConditionFields::requiredCount, (StreamCodec)ByteBufCodecs.STRING_UTF8, DroneConditionFields::measureVar, DroneConditionFields::new);

        public DroneConditionFields withIsAndFunc(boolean isAndFunc) {
            return new DroneConditionFields(isAndFunc, this.op, this.requiredCount, this.measureVar);
        }

        public DroneConditionFields withOp(ICondition.Operator op) {
            return new DroneConditionFields(this.isAndFunc, op, this.requiredCount, this.measureVar);
        }

        public DroneConditionFields withRequiredCount(int requiredCount) {
            return new DroneConditionFields(this.isAndFunc, this.op, requiredCount, this.measureVar);
        }

        public DroneConditionFields withMeasureVar(String measureVar) {
            return new DroneConditionFields(this.isAndFunc, this.op, this.requiredCount, measureVar);
        }
    }
}

