/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.ai.DroneAICrafting;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.recipes.VanillaRecipeCache;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ProgWidgetCrafting
extends ProgWidget
implements ICraftingWidget,
ICountWidget,
ISidedWidget {
    public static final MapCodec<ProgWidgetCrafting> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetCrafting.baseParts(builder).and(builder.group((App)Codec.BOOL.optionalFieldOf("use_count", (Object)false).forGetter(ProgWidgetCrafting::useCount), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ProgWidgetCrafting::getCount))).apply((Applicative)builder, ProgWidgetCrafting::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetCrafting> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetCrafting::useCount, (StreamCodec)ByteBufCodecs.VAR_INT, ProgWidgetCrafting::getCount, ProgWidgetCrafting::new);
    private static final boolean[] NO_SIDES = new boolean[6];
    private boolean useCount;
    private int count;
    private boolean usingVariables;

    public ProgWidgetCrafting(ProgWidget.PositionFields pos, boolean useCount, int count) {
        super(pos);
        this.useCount = useCount;
        this.count = count;
    }

    public ProgWidgetCrafting() {
        this(ProgWidget.PositionFields.DEFAULT, false, 1);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetCrafting(this.getPosition(), this.useCount, this.count);
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        this.getCraftingGrid();
        if (!this.usingVariables && this.getRecipeResult(ClientUtils.getClientLevel()).isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.crafting.error.noCraftingRecipe", new Object[0]));
        }
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.CRAFTING.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        ItemStack stack = this.getRecipeResult(ClientUtils.getClientLevel());
        if (!stack.isEmpty()) {
            curTooltip.add((Component)stack.getHoverName().copy().withStyle(ChatFormatting.YELLOW));
        }
        if (this.useCount()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.usingCount", this.getCount()));
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.ITEM_FILTER.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PURPLE;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CRAFTING;
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public CraftingInput getCraftingGrid() {
        this.usingVariables = false;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Collections.nCopies(9, ItemStack.EMPTY));
        for (int y = 0; y < 3; ++y) {
            ProgWidgetItemFilter itemFilter = (ProgWidgetItemFilter)this.getConnectedParameters()[y];
            for (int x = 0; x < 3 && itemFilter != null; ++x) {
                if (!itemFilter.getVariable().isEmpty()) {
                    this.usingVariables = true;
                }
                stacks.set(y * 3 + x, itemFilter.getFilter());
                itemFilter = (ProgWidgetItemFilter)itemFilter.getConnectedParameters()[0];
            }
        }
        return CraftingInput.of((int)3, (int)3, stacks);
    }

    public ItemStack getRecipeResult(Level level) {
        CraftingInput grid = this.getCraftingGrid();
        return this.getRecipe(level, grid).map(r -> r.assemble((RecipeInput)grid, (HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
    }

    @Override
    public Optional<CraftingRecipe> getRecipe(Level level, CraftingInput grid) {
        return this.usingVariables ? level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)grid, level).flatMap(holder -> Optional.of((CraftingRecipe)holder.value())) : VanillaRecipeCache.CRAFTING.getCachedRecipe(level, grid);
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAICrafting(drone, (ICraftingWidget)((Object)widget));
    }

    @Override
    public void setSides(boolean[] sides) {
    }

    @Override
    public boolean[] getSides() {
        return NO_SIDES;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetCrafting that = (ProgWidgetCrafting)o;
        return this.baseEquals(that) && this.useCount == that.useCount && this.count == that.count && this.usingVariables == that.usingVariables;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.useCount, this.count, this.usingVariables);
    }
}

