/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class ProgWidgetCoordinate
extends ProgWidget
implements IVariableWidget {
    public static final MapCodec<ProgWidgetCoordinate> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetCoordinate.baseParts(builder).and(builder.group((App)BlockPos.CODEC.optionalFieldOf("coord", (Object)BlockPos.ZERO).forGetter(p -> p.coord), (App)Codec.STRING.optionalFieldOf("var", (Object)"").forGetter(ProgWidgetCoordinate::getVariable), (App)Codec.BOOL.optionalFieldOf("using_var", (Object)false).forGetter(ProgWidgetCoordinate::isUsingVariable))).apply((Applicative)builder, ProgWidgetCoordinate::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetCoordinate> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)BlockPos.STREAM_CODEC, p -> p.coord, (StreamCodec)ByteBufCodecs.STRING_UTF8, ProgWidgetCoordinate::getVariable, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetCoordinate::isUsingVariable, ProgWidgetCoordinate::new);
    private BlockPos coord = BlockPos.ZERO;
    private String variable = "";
    private boolean useVariable;
    private DroneAIManager aiManager;

    public ProgWidgetCoordinate() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    private ProgWidgetCoordinate(ProgWidget.PositionFields pos, BlockPos coord, String variable, boolean useVariable) {
        super(pos);
        this.coord = coord;
        this.variable = variable;
        this.useVariable = useVariable;
    }

    public static ProgWidgetCoordinate fromPos(BlockPos pos) {
        ProgWidgetCoordinate w = new ProgWidgetCoordinate();
        w.setCoordinate(pos);
        return w;
    }

    public static ProgWidgetCoordinate fromGPSTool(ItemStack gpsTool) {
        ProgWidgetCoordinate w = new ProgWidgetCoordinate();
        w.loadFromGPSTool(gpsTool);
        return w;
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetCoordinate(this.getPosition(), this.coord, this.variable, this.useVariable);
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgetTypes.COORDINATE.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.COORDINATE.get());
    }

    @Override
    public void addWarnings(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addWarnings(curInfo, widgets);
        if (!this.useVariable && this.coord == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.warning.noCoordinate", new Object[0]));
        }
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.useVariable && this.variable.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.emptyVariable", new Object[0]));
        }
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GREEN;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_COORDINATE;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public Optional<BlockPos> getCoordinate() {
        if (this.useVariable && this.aiManager != null) {
            return this.aiManager.getCoordinate(this.aiManager.getDrone().getOwnerUUID(), this.variable);
        }
        return this.getRawCoordinate();
    }

    public Optional<BlockPos> getRawCoordinate() {
        return Optional.ofNullable(this.coord);
    }

    public void setCoordinate(BlockPos pos) {
        this.coord = pos;
    }

    public void setVariable(String varName) {
        this.variable = varName;
    }

    public String getVariable() {
        return this.variable;
    }

    public boolean isUsingVariable() {
        return this.useVariable;
    }

    public void setUsingVariable(boolean useVariable) {
        this.useVariable = useVariable;
    }

    public void loadFromGPSTool(ItemStack gpsTool) {
        String variable = GPSToolItem.getVariable(gpsTool);
        if (variable.isEmpty()) {
            this.setCoordinate(GPSToolItem.getGPSLocation(gpsTool).orElse(BlockPos.ZERO));
            this.setUsingVariable(false);
        } else {
            this.setVariable(variable);
            this.setUsingVariable(true);
        }
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.COORDINATE.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.useVariable) {
            curTooltip.add((Component)Component.literal((String)("XYZ: var '" + this.variable + "'")));
        } else {
            curTooltip.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.coord)));
        }
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return this.useVariable ? Collections.singletonList(this.varAsTextComponent(this.variable)) : Collections.singletonList(Component.literal((String)PneumaticCraftUtils.posToString(this.coord)));
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetCoordinate that = (ProgWidgetCoordinate)o;
        return this.baseEquals(that) && this.useVariable == that.useVariable && Objects.equals(this.coord, that.coord) && Objects.equals(this.variable, that.variable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.coord, this.variable, this.useVariable);
    }
}

