/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import me.desht.pneumaticcraft.common.config.subconfig.ProgWidgetConfig;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ProgWidget
implements IProgWidget {
    public static final Codec<IProgWidget> CODEC = PNCRegistries.PROG_WIDGETS_REGISTRY.byNameCodec().dispatch(IProgWidget::getType, ProgWidgetType::codec);
    public static final Codec<List<IProgWidget>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<RegistryFriendlyByteBuf, IProgWidget> STREAM_CODEC = ByteBufCodecs.registry(PNCRegistries.PROG_WIDGETS_KEY).dispatch(IProgWidget::getType, ProgWidgetType::streamCodec);
    public static final int JSON_VERSION = 3;
    public static final int PROGWIDGET_WIDTH = 30;
    public static final int PROGWIDGET_HEIGHT = 22;
    static final MutableComponent ALL_TEXT = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.all", new Object[0]);
    static final MutableComponent NONE_TEXT = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]);
    protected PositionFields positionFields;
    private IProgWidget[] connectedParameters;
    private IProgWidget outputStepConnection;
    private IProgWidget parent;
    private Pair<Float, Float> maxUV = null;

    protected static <P extends ProgWidget> Products.P1<RecordCodecBuilder.Mu<P>, PositionFields> baseParts(RecordCodecBuilder.Instance<P> pInstance) {
        return pInstance.group((App)PositionFields.CODEC.fieldOf("pos").forGetter(ProgWidget::getPosition));
    }

    protected ProgWidget(PositionFields pos) {
        this.positionFields = pos;
        if (!this.getParameters().isEmpty()) {
            this.connectedParameters = new IProgWidget[this.getParameters().size() * 2];
        }
    }

    protected static byte encodeSides(boolean[] sides) {
        boolean res = false;
        for (int i = 0; i < 6; ++i) {
            res |= sides[i] ? 1 << i : 0;
        }
        return (byte)(res ? 1 : 0);
    }

    protected static boolean[] decodeSides(byte val) {
        boolean[] res = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            res[i] = (val & 1 << i) != 0;
        }
        return res;
    }

    @Override
    public abstract ProgWidgetType<?> getType();

    @Override
    public final ResourceLocation getTypeID() {
        return PNCRegistries.PROG_WIDGETS_REGISTRY.getKey(this.getType());
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        curTooltip.add((Component)PneumaticCraftUtils.xlate(this.getTranslationKey(), new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.UNDERLINE}));
        if (this.freeToUse()) {
            curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.comment.tooltip.freeToUse"));
        }
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.emptyList();
    }

    @Override
    public void addWarnings(List<Component> curInfo, List<IProgWidget> widgets) {
        ProgWidget progWidget = this;
        if (progWidget instanceof IVariableWidget) {
            IVariableWidget variableWidget = (IVariableWidget)((Object)progWidget);
            for (String variable : (HashSet)Util.make(new HashSet(), variableWidget::addVariables)) {
                if (variable.isEmpty() || variable.startsWith("#") || variable.startsWith("$") || ProgWidget.isVariableSetAnywhere(widgets, variable)) continue;
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.warning.variableNeverSet", variable));
            }
        }
    }

    private static boolean isVariableSetAnywhere(List<IProgWidget> widgets, String variable) {
        for (IProgWidget widget : widgets) {
            if (!(widget instanceof IVariableSetWidget)) continue;
            IVariableSetWidget vsw = (IVariableSetWidget)((Object)widget);
            Set variables = (Set)Util.make(new HashSet(), vsw::addVariables);
            if (!variables.contains(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        if (!this.hasStepInput() && this.hasStepOutput() && this.outputStepConnection == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noPieceConnected", new Object[0]));
        }
    }

    @Override
    public boolean isAvailable() {
        return !ProgWidgetConfig.INSTANCE.isWidgetBlacklisted(this.getType());
    }

    public PositionFields getPosition() {
        return this.positionFields;
    }

    @Override
    public final int getX() {
        return this.positionFields.x;
    }

    @Override
    public final int getY() {
        return this.positionFields.y;
    }

    @Override
    public final void setX(int x) {
        this.positionFields = new PositionFields(x, this.positionFields.y);
    }

    @Override
    public final void setY(int y) {
        this.positionFields = new PositionFields(this.positionFields.x, y);
    }

    @Override
    public int getWidth() {
        return 30;
    }

    @Override
    public int getHeight() {
        return 22 * Math.max(1, this.getParameters().size());
    }

    @Override
    public final void setParent(IProgWidget widget) {
        this.parent = widget;
    }

    @Override
    public final IProgWidget getParent() {
        return this.parent;
    }

    @Override
    public final Pair<Float, Float> getMaxUV() {
        if (this.maxUV == null) {
            int textureSize;
            int width = this.getWidth() + (this.getParameters().isEmpty() ? 0 : 10);
            int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
            int maxSize = Math.max(width, height);
            for (textureSize = 1; textureSize < maxSize; textureSize *= 2) {
            }
            float u = (float)width / (float)textureSize;
            float v = (float)height / (float)textureSize;
            this.maxUV = new ImmutablePair((Object)Float.valueOf(u), (Object)Float.valueOf(v));
        }
        return this.maxUV;
    }

    @Override
    public boolean hasStepOutput() {
        return this.hasStepInput();
    }

    @Override
    public Goal getWidgetTargetAI(IDrone drone, IProgWidget widget) {
        return null;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return null;
    }

    @Override
    public final void setParameter(int index, IProgWidget paramWidget) {
        int index2;
        int n = index2 = index >= this.getParameters().size() ? index - this.getParameters().size() : index;
        if (this.connectedParameters != null && (paramWidget == null || paramWidget.getType() == this.getParameters().get(index2))) {
            this.connectedParameters[index] = paramWidget;
        }
    }

    @Override
    public boolean canSetParameter(int index) {
        if (this.connectedParameters != null) {
            return this.hasBlacklist() || index < this.connectedParameters.length / 2;
        }
        return false;
    }

    protected boolean hasBlacklist() {
        return true;
    }

    @Override
    public IProgWidget[] getConnectedParameters() {
        return this.connectedParameters;
    }

    @Override
    public void setOutputWidget(IProgWidget widget) {
        this.outputStepConnection = widget;
    }

    @Override
    public IProgWidget getOutputWidget() {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget getOutputWidget(IDrone drone, List<IProgWidget> allWidgets) {
        return this.outputStepConnection;
    }

    static <T extends IProgWidget> List<T> getConnectedWidgetList(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        ProgWidget.validateType(widget, parameterIndex, type);
        IProgWidget connectingWidget = widget.getConnectedParameters()[parameterIndex];
        if (connectingWidget != null) {
            ArrayList<T> list = new ArrayList<T>();
            while (connectingWidget != null) {
                list.add(type.cast(connectingWidget));
                connectingWidget = connectingWidget.getConnectedParameters()[0];
            }
            return list;
        }
        return null;
    }

    private static <T extends IProgWidget> void validateType(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        int l = widget.getParameters().size();
        if (parameterIndex >= l) {
            parameterIndex -= l;
        }
        if (type != widget.getParameters().get(parameterIndex)) {
            throw new IllegalArgumentException(String.format("invalid type %s for parameter %d (expected %s)", type, parameterIndex, widget.getParameters().get(parameterIndex)));
        }
    }

    @Override
    public boolean canBeRunByComputers(IDrone drone, IProgWidget widget) {
        return this.getWidgetAI(drone, widget) != null;
    }

    Component varAsTextComponent(String var) {
        return var.isEmpty() ? Component.empty() : Component.literal((String)("\"" + var + "\""));
    }

    protected boolean baseEquals(ProgWidget other) {
        return this.positionFields.equals(other.positionFields);
    }

    protected int baseHashCode() {
        return this.positionFields.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidget that = (ProgWidget)o;
        return this.baseEquals(that);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public record PositionFields(int x, int y) {
        public static final PositionFields DEFAULT = new PositionFields(0, 0);
        public static final Codec<PositionFields> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("x").forGetter(PositionFields::x), (App)Codec.INT.fieldOf("y").forGetter(PositionFields::y)).apply((Applicative)builder, PositionFields::new));
        public static final StreamCodec<FriendlyByteBuf, PositionFields> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PositionFields::x, (StreamCodec)ByteBufCodecs.INT, PositionFields::y, PositionFields::new);

        public static PositionFields rightParam(IProgWidget widget, int paramIdx) {
            return new PositionFields(widget.getX() + widget.getWidth() / 2, widget.getY() + paramIdx * 22 / 2);
        }

        public static PositionFields leftParam(IProgWidget widget, int paramIdx) {
            int width = widget.getParameters().get(paramIdx).create().getWidth();
            return new PositionFields(widget.getX() - width / 2, widget.getY() + paramIdx * 11);
        }

        public static PositionFields below(IProgWidget widget) {
            return new PositionFields(widget.getX(), widget.getY() + widget.getHeight() / 2);
        }
    }

    public record Versioned(int version, List<IProgWidget> widgets) {
        public static final Codec<Versioned> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("version").forGetter(Versioned::version), (App)LIST_CODEC.fieldOf("widgets").forGetter(Versioned::widgets)).apply((Applicative)builder, Versioned::new));
    }
}

