/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.dispenser;

import me.desht.pneumaticcraft.common.item.DroneItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class DroneDispenseBehavior
extends DefaultDispenseItemBehavior {
    private static final DroneDispenseBehavior DRONE_DISPENSE = new DroneDispenseBehavior();

    public static void registerDrones() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.DRONE.get()), (DispenseItemBehavior)DRONE_DISPENSE);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.LOGISTICS_DRONE.get()), (DispenseItemBehavior)DRONE_DISPENSE);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.HARVESTING_DRONE.get()), (DispenseItemBehavior)DRONE_DISPENSE);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.GUARD_DRONE.get()), (DispenseItemBehavior)DRONE_DISPENSE);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.COLLECTOR_DRONE.get()), (DispenseItemBehavior)DRONE_DISPENSE);
    }

    protected ItemStack execute(BlockSource source, ItemStack stack) {
        Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos placePos = source.pos().relative(facing);
        ((DroneItem)stack.getItem()).spawnDrone(null, (Level)source.level(), source.pos().relative(facing, 2), facing.getOpposite(), placePos, stack);
        stack.shrink(1);
        return stack;
    }
}

