/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.entity.projectile.MicromissileEntity;
import me.desht.pneumaticcraft.common.inventory.AirCannonMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.EntityDistanceComparator;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ItemLaunching;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import me.desht.pneumaticcraft.mixin.accessors.ItemEntityAccess;
import me.desht.pneumaticcraft.mixin.accessors.ServerPlayerAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class AirCannonBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<AirCannonBlockEntity>,
IGUIButtonSensitive,
MenuProvider {
    private static final String FP_NAME = "[Air Cannon]";
    private static final GameProfile FAKE_PROFILE = UUIDUtil.createOfflineProfile((String)"[Air Cannon]");
    private static final List<RedstoneController.RedstoneMode<AirCannonBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<AirCannonBlockEntity>("airCannon.highSignalAndAngle", Textures.GUI_HIGH_SIGNAL_ANGLE, te -> te.getCurrentRedstonePower() > 0 && te.doneTurning), new RedstoneController.ReceivingRedstoneMode<AirCannonBlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.REDSTONE_TORCH), te -> te.getCurrentRedstonePower() > 0), new RedstoneController.ReceivingRedstoneMode<AirCannonBlockEntity>("airCannon.highAndSpace", Textures.GUI_HIGH_SIGNAL_SPACE, te -> te.getCurrentRedstonePower() > 0 && te.inventoryCanCarry()));
    private final AirCannonStackHandler itemHandler = new AirCannonStackHandler(this);
    @DescSynced
    @LazySynced
    public float rotationAngle;
    @DescSynced
    @LazySynced
    public float heightAngle;
    @GuiSynced
    public int forceMult = 100;
    @DescSynced
    private float targetRotationAngle;
    @DescSynced
    private float targetHeightAngle;
    @GuiSynced
    public boolean doneTurning = false;
    @GuiSynced
    public int gpsX;
    @GuiSynced
    public int gpsY;
    @GuiSynced
    public int gpsZ;
    @GuiSynced
    public boolean coordWithinReach;
    @GuiSynced
    private final RedstoneController<AirCannonBlockEntity> rsController = new RedstoneController<AirCannonBlockEntity>(this, REDSTONE_MODES);
    private int oldRangeUpgrades;
    private boolean externalControl;
    private boolean entityUpgradeInserted;
    private boolean dispenserUpgradeInserted;
    private final List<ItemEntity> trackedItems = new ArrayList<ItemEntity>();
    private Set<UUID> trackedItemIds;
    private final Set<PrimedTnt> trackedTNT = new HashSet<PrimedTnt>();
    private BlockPos lastInsertingInventory;
    private Direction lastInsertingInventorySide;
    @GuiSynced
    public boolean insertingInventoryHasSpace = true;
    private boolean gpsSlotChanged = true;
    private FakePlayer fakePlayer = null;
    private final AtomicBoolean firePending = new AtomicBoolean(false);
    private final AtomicBoolean lastFireOK = new AtomicBoolean(false);
    private static final int INVENTORY_SIZE = 2;
    private static final int CANNON_SLOT = 0;
    private static final int GPS_SLOT = 1;

    public AirCannonBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.AIR_CANNON.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
    }

    @Override
    public void tickCommonPre() {
        boolean isEntityTrackerUpgradeInserted;
        int curRangeUpgrades;
        super.tickCommonPre();
        boolean destUpdateNeeded = false;
        if (this.gpsSlotChanged) {
            destUpdateNeeded = this.checkGPSSlot();
            this.gpsSlotChanged = false;
        }
        if ((curRangeUpgrades = Math.min(8, this.getUpgrades(ModUpgrades.RANGE.get()))) != this.oldRangeUpgrades) {
            this.oldRangeUpgrades = curRangeUpgrades;
            if (!this.externalControl) {
                destUpdateNeeded = true;
            }
        }
        boolean isDispenserUpgradeInserted = this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0;
        boolean bl = isEntityTrackerUpgradeInserted = this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0;
        if (this.dispenserUpgradeInserted != isDispenserUpgradeInserted || this.entityUpgradeInserted != isEntityTrackerUpgradeInserted) {
            this.dispenserUpgradeInserted = isDispenserUpgradeInserted;
            this.entityUpgradeInserted = isEntityTrackerUpgradeInserted;
            destUpdateNeeded = true;
        }
        if (destUpdateNeeded) {
            this.updateDestination();
        }
        this.updateRotationAngles();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.firePending.get()) {
            this.lastFireOK.set(this.fire());
        }
        this.updateTrackedItems();
        this.updateTrackedTNT();
        this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation() : null);
    }

    private void updateTrackedTNT() {
        Iterator<PrimedTnt> iter = this.trackedTNT.iterator();
        while (iter.hasNext()) {
            PrimedTnt e = iter.next();
            if (!e.isAlive()) {
                iter.remove();
                continue;
            }
            if (e.tickCount <= 5 || !(e.getDeltaMovement().lengthSqr() < 0.01)) continue;
            e.setFuse(0);
        }
    }

    private boolean checkGPSSlot() {
        List<BlockPos> posList;
        ItemStack gpsStack = this.itemHandler.getStackInSlot(1);
        if (gpsStack.getItem() instanceof IPositionProvider && !this.externalControl && !(posList = ((IPositionProvider)gpsStack.getItem()).getStoredPositions(null, gpsStack)).isEmpty() && posList.getFirst() != null) {
            int destinationX = posList.getFirst().getX();
            int destinationY = posList.getFirst().getY();
            int destinationZ = posList.getFirst().getZ();
            if (destinationX != this.gpsX || destinationY != this.gpsY || destinationZ != this.gpsZ) {
                this.gpsX = destinationX;
                this.gpsY = destinationY;
                this.gpsZ = destinationZ;
                return true;
            }
        }
        return false;
    }

    private void updateRotationAngles() {
        this.doneTurning = true;
        float speedMultiplier = this.getSpeedMultiplierFromUpgrades();
        if (this.rotationAngle < this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle < this.targetRotationAngle - 20.0f ? (this.rotationAngle += 3.0f * speedMultiplier) : (this.rotationAngle += 0.5f * speedMultiplier);
            if (this.rotationAngle > this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.rotationAngle > this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle > this.targetRotationAngle + 20.0f ? (this.rotationAngle -= 3.0f * speedMultiplier) : (this.rotationAngle -= 0.5f * speedMultiplier);
            if (this.rotationAngle < this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle < this.targetHeightAngle) {
            this.heightAngle = this.heightAngle < this.targetHeightAngle - 20.0f ? (this.heightAngle += 3.0f * speedMultiplier) : (this.heightAngle += 0.5f * speedMultiplier);
            if (this.heightAngle > this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle > this.targetHeightAngle) {
            this.heightAngle = this.heightAngle > this.targetHeightAngle + 20.0f ? (this.heightAngle -= 3.0f * speedMultiplier) : (this.heightAngle -= 0.5f * speedMultiplier);
            if (this.heightAngle < this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
    }

    private void updateTrackedItems() {
        Level level;
        if (this.trackedItemIds != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.trackedItems.clear();
            serverLevel.getEntities().get(EntityTypeTest.forClass(ItemEntity.class), itemEntity -> {
                if (this.trackedItemIds.contains(itemEntity.getUUID())) {
                    this.trackedItems.add((ItemEntity)itemEntity);
                }
                return AbortableIterationConsumer.Continuation.CONTINUE;
            });
            this.trackedItemIds = null;
        }
        Iterator<ItemEntity> iterator = this.trackedItems.iterator();
        block0: while (iterator.hasNext()) {
            ItemEntity item = iterator.next();
            if (item.level() != this.getLevel() || !item.isAlive()) {
                iterator.remove();
                continue;
            }
            HashMap<BlockPos, Direction> positions = new HashMap<BlockPos, Direction>();
            double range = 0.2;
            for (Direction d : Direction.values()) {
                double posX = item.getX() + (double)d.getStepX() * range;
                double posY = item.getY() + (double)d.getStepY() * range;
                double posZ = item.getZ() + (double)d.getStepZ() * range;
                positions.put(new BlockPos((int)Math.floor(posX), (int)Math.floor(posY), (int)Math.floor(posZ)), d.getOpposite());
            }
            for (Map.Entry entry : positions.entrySet()) {
                boolean inserted;
                BlockPos pos = (BlockPos)entry.getKey();
                BlockEntity te = this.getLevel().getBlockEntity(pos);
                if (te == null || !(inserted = IOHelper.getInventoryForBlock(te, (Direction)entry.getValue()).map(inv -> {
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)item.getItem(), (boolean)false);
                    if (!remainder.isEmpty()) {
                        item.setItem(remainder);
                        this.insertingInventoryHasSpace = false;
                        return false;
                    }
                    item.discard();
                    iterator.remove();
                    this.lastInsertingInventory = te.getBlockPos();
                    this.lastInsertingInventorySide = (Direction)entry.getValue();
                    this.nonNullLevel().playSound(null, te.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return true;
                }).orElse(false).booleanValue())) continue;
                continue block0;
            }
        }
    }

    private void updateDestination() {
        this.doneTurning = false;
        double payloadFrictionY = 0.98;
        double payloadFrictionX = 0.98;
        double payloadGravity = 0.04;
        if (this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0) {
            payloadFrictionX = 0.91;
            payloadGravity = 0.08;
        } else if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0 && !this.itemHandler.getStackInSlot(0).isEmpty()) {
            Item item = this.itemHandler.getStackInSlot(0).getItem();
            if (item == Items.POTION || item == Items.EXPERIENCE_BOTTLE || item == Items.EGG || item == Items.SNOWBALL) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.03;
            } else if (item == Items.ARROW) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.05;
            } else if (item == Items.MINECART || item == Items.CHEST_MINECART || item == Items.HOPPER_MINECART || item == Items.TNT_MINECART || item == Items.FURNACE_MINECART) {
                payloadFrictionY = 0.95;
            } else if (item == Items.FIRE_CHARGE) {
                payloadGravity = 0.0;
            }
            if (item == Items.POTION) {
                payloadGravity = 0.05;
            } else if (item == Items.EXPERIENCE_BOTTLE) {
                payloadGravity = 0.07;
            }
            payloadFrictionX = payloadFrictionY;
            if (item instanceof BoatItem) {
                payloadFrictionX = 0.99;
                payloadFrictionY = 0.95;
            }
            if (item instanceof SpawnEggItem) {
                payloadFrictionY = 0.98;
                payloadFrictionX = 0.91;
                payloadGravity = 0.08;
            }
        }
        double deltaX = this.gpsX - this.getBlockPos().getX();
        double deltaZ = this.gpsZ - this.getBlockPos().getZ();
        float calculatedRotationAngle = AirCannonBlockEntity.calculateRotationAngle(deltaX, deltaZ);
        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double deltaY = this.gpsY - this.getBlockPos().getY();
        float calculatedHeightAngle = this.calculateBestHeightAngle(distance, deltaY, this.getForce(), payloadGravity, payloadFrictionX, payloadFrictionY);
        this.setTargetAngles(calculatedRotationAngle, calculatedHeightAngle);
    }

    private static float calculateRotationAngle(double deltaX, double deltaZ) {
        float calculatedRotationAngle;
        double angleXZ = Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0;
        if (deltaX >= 0.0 && deltaZ < 0.0) {
            calculatedRotationAngle = (float)angleXZ;
        } else {
            double angleZX = Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0;
            calculatedRotationAngle = deltaX >= 0.0 ? (float)angleZX + 90.0f : (deltaZ >= 0.0 ? (float)angleXZ + 180.0f : (float)angleZX + 270.0f);
        }
        return calculatedRotationAngle;
    }

    private float calculateBestHeightAngle(double distance, double deltaY, float force, double payloadGravity, double payloadFrictionX, double payloadFrictionY) {
        double bestAngle = 0.0;
        double bestDistance = 3.4028234663852886E38;
        if (payloadGravity == 0.0) {
            return 90.0f - (float)(Math.atan(deltaY / distance) * 180.0 / Math.PI);
        }
        for (double i = 0.031415926535897934; i < 1.5707963267948966; i += 0.01) {
            double motionX = Mth.cos((float)((float)i)) * force;
            double posX = 0.0;
            double posY = 0.0;
            for (double motionY = (double)(Mth.sin((float)((float)i)) * force); posY > deltaY || motionY > 0.0; motionY *= payloadFrictionY) {
                posX += motionX;
                posY += motionY;
                motionY -= payloadGravity;
                motionX *= payloadFrictionX;
            }
            double distanceToTarget = Math.abs(distance - posX);
            if (!(distanceToTarget < bestDistance)) continue;
            bestDistance = distanceToTarget;
            bestAngle = i;
        }
        this.coordWithinReach = bestDistance < 1.5;
        return 90.0f - (float)(bestAngle * 180.0 / Math.PI);
    }

    private synchronized void setTargetAngles(float rotationAngle, float heightAngle) {
        this.targetRotationAngle = rotationAngle;
        this.targetHeightAngle = heightAngle;
    }

    private double[] getVelocityVector(float angleX, float angleZ, float force) {
        double[] velocities = new double[]{Mth.sin((float)(angleZ / 180.0f * (float)Math.PI)), Mth.cos((float)(angleX / 180.0f * (float)Math.PI)), Mth.cos((float)(angleZ / 180.0f * (float)Math.PI)) * -1.0f};
        velocities[0] = velocities[0] * (double)Mth.sin((float)(angleX / 180.0f * (float)Math.PI));
        velocities[2] = velocities[2] * (double)Mth.sin((float)(angleX / 180.0f * (float)Math.PI));
        double vectorTotal = velocities[0] * velocities[0] + velocities[1] * velocities[1] + velocities[2] * velocities[2];
        vectorTotal = (double)force / vectorTotal;
        int i = 0;
        while (i < 3) {
            int n = i++;
            velocities[n] = velocities[n] * vectorTotal;
        }
        return velocities;
    }

    public boolean hasCoordinate() {
        return this.gpsX != 0 || this.gpsY != 0 || this.gpsZ != 0;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    public float getForce() {
        return (0.5f + (float)this.oldRangeUpgrades / 2.0f) * (float)this.forceMult / 100.0f;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.targetRotationAngle = tag.getFloat("targetRotationAngle");
        this.targetHeightAngle = tag.getFloat("targetHeightAngle");
        this.rotationAngle = tag.getFloat("rotationAngle");
        this.heightAngle = tag.getFloat("heightAngle");
        this.gpsX = tag.getInt("gpsX");
        this.gpsY = tag.getInt("gpsY");
        this.gpsZ = tag.getInt("gpsZ");
        this.coordWithinReach = tag.getBoolean("targetWithinReach");
        this.itemHandler.deserializeNBT(provider, tag.getCompound("Items"));
        this.forceMult = tag.getInt("forceMult");
        this.trackedItemIds = new HashSet<UUID>();
        ListTag tagList = tag.getList("trackedItems", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag t = tagList.getCompound(i);
            this.trackedItemIds.add(new UUID(t.getLong("UUIDMost"), t.getLong("UUIDLeast")));
        }
        if (tag.contains("inventoryX")) {
            this.lastInsertingInventory = new BlockPos(tag.getInt("inventoryX"), tag.getInt("inventoryY"), tag.getInt("inventoryZ"));
            this.lastInsertingInventorySide = Direction.from3DDataValue((int)tag.getByte("inventorySide"));
        } else {
            this.lastInsertingInventory = null;
            this.lastInsertingInventorySide = null;
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("targetRotationAngle", this.targetRotationAngle);
        tag.putFloat("targetHeightAngle", this.targetHeightAngle);
        tag.putFloat("rotationAngle", this.rotationAngle);
        tag.putFloat("heightAngle", this.heightAngle);
        tag.putInt("gpsX", this.gpsX);
        tag.putInt("gpsY", this.gpsY);
        tag.putInt("gpsZ", this.gpsZ);
        tag.putBoolean("targetWithinReach", this.coordWithinReach);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(provider));
        tag.putInt("forceMult", this.forceMult);
        ListTag tagList = new ListTag();
        for (ItemEntity entity : this.trackedItems) {
            UUID uuid = entity.getUUID();
            CompoundTag t = new CompoundTag();
            t.putLong("UUIDMost", uuid.getMostSignificantBits());
            t.putLong("UUIDLeast", uuid.getLeastSignificantBits());
            tagList.add((Object)t);
        }
        tag.put("trackedItems", (Tag)tagList);
        if (this.lastInsertingInventory != null) {
            tag.putInt("inventoryX", this.lastInsertingInventory.getX());
            tag.putInt("inventoryY", this.lastInsertingInventory.getY());
            tag.putInt("inventoryZ", this.lastInsertingInventory.getZ());
            tag.putByte("inventorySide", (byte)this.lastInsertingInventorySide.get3DDataValue());
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new AirCannonMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public RedstoneController<AirCannonBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            if (this.rsController.getCurrentMode() == 2 && this.getUpgrades(ModUpgrades.BLOCK_TRACKER.get()) == 0) {
                this.rsController.setCurrentMode(0);
            }
            return;
        }
        int oldForceMult = this.forceMult;
        switch (tag) {
            case "--": {
                this.forceMult = Math.max(this.forceMult - 10, 0);
                break;
            }
            case "-": {
                this.forceMult = Math.max(this.forceMult - 1, 0);
                break;
            }
            case "+": {
                this.forceMult = Math.min(this.forceMult + 1, 100);
                break;
            }
            case "++": {
                this.forceMult = Math.min(this.forceMult + 10, 100);
            }
        }
        if (this.forceMult != oldForceMult) {
            this.updateDestination();
        }
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        boolean isPowered;
        boolean wasPowered = this.rsController.getCurrentRedstonePower() > 0;
        super.onNeighborBlockUpdate(fromPos);
        boolean bl = isPowered = this.rsController.getCurrentRedstonePower() > 0;
        if (isPowered && !wasPowered && this.rsController.shouldRun()) {
            this.lastFireOK.set(this.fire());
        }
    }

    private boolean inventoryCanCarry() {
        this.insertingInventoryHasSpace = true;
        if (this.lastInsertingInventory == null) {
            return true;
        }
        if (this.itemHandler.getStackInSlot(0).isEmpty()) {
            return true;
        }
        BlockEntity te = this.nonNullLevel().getBlockEntity(this.lastInsertingInventory);
        return IOHelper.getInventoryForBlock(te, this.lastInsertingInventorySide).map(inv -> {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)this.itemHandler.getStackInSlot(0).copy(), (boolean)true);
            this.insertingInventoryHasSpace = remainder.isEmpty();
            return this.insertingInventoryHasSpace;
        }).orElseGet(() -> {
            this.lastInsertingInventory = null;
            this.lastInsertingInventorySide = null;
            return true;
        });
    }

    private synchronized boolean requestFire() {
        this.firePending.set(true);
        return true;
    }

    private boolean fire() {
        Entity launchedEntity = this.getCloseEntityIfUpgraded();
        this.firePending.set(false);
        if (this.getPressure() >= 2.0f && (launchedEntity != null || !this.itemHandler.getStackInSlot(0).isEmpty())) {
            float force = this.getForce();
            double[] velocity = this.getVelocityVector(this.heightAngle, this.rotationAngle, force);
            this.addAir((int)(-500.0f * force));
            boolean shootingInventory = false;
            if (launchedEntity == null) {
                shootingInventory = true;
                launchedEntity = this.getPayloadEntity();
                if (launchedEntity instanceof PrimedTnt) {
                    PrimedTnt tnt = (PrimedTnt)launchedEntity;
                    tnt.setFuse(400);
                    this.trackedTNT.add(tnt);
                }
                if (launchedEntity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)launchedEntity;
                    this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                    if (this.getUpgrades(ModUpgrades.BLOCK_TRACKER.get()) > 0) {
                        this.trackedItems.add(itemEntity);
                    }
                    itemEntity.setPickUpDelay(20);
                } else if (!(launchedEntity instanceof MicromissileEntity)) {
                    this.itemHandler.extractItem(0, 1, false);
                }
            } else if (launchedEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)launchedEntity;
                if (serverPlayer.connection.isAcceptingMessages()) {
                    ((ServerPlayerAccess)serverPlayer).setIsChangingDimension(true);
                    serverPlayer.teleportTo((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.8, (double)this.getBlockPos().getZ() + 0.5);
                }
            }
            ItemLaunching.launchEntity(launchedEntity, new Vec3((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.8, (double)this.getBlockPos().getZ() + 0.5), new Vec3(velocity[0], velocity[1], velocity[2]), shootingInventory);
            return true;
        }
        return false;
    }

    private Entity getPayloadEntity() {
        Entity e = ItemLaunching.getEntityToLaunch(this.getLevel(), this.itemHandler.getStackInSlot(0), (ServerPlayer)this.getFakePlayer(), this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0, false);
        if (e instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)e;
            ((ItemEntityAccess)itemEntity).setAge(4800);
            itemEntity.lifespan += Math.min(this.getUpgrades(ModUpgrades.ITEM_LIFE.get()) * 600, 4800);
        }
        return e;
    }

    private FakePlayer getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.getLevel()), (GameProfile)FAKE_PROFILE);
            this.fakePlayer.setPos((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5);
        }
        return this.fakePlayer;
    }

    public void setRemoved() {
        super.setRemoved();
        this.fakePlayer = null;
    }

    private Entity getCloseEntityIfUpgraded() {
        List entities;
        int entityUpgrades = Math.min(5, this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()));
        if (entityUpgrades > 0 && !(entities = this.nonNullLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos()).inflate((double)entityUpgrades))).isEmpty()) {
            entities.sort(new EntityDistanceComparator(this.getBlockPos()));
            return (Entity)entities.getFirst();
        }
        return null;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("setTargetLocation"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 3, "x, y, z");
                AirCannonBlockEntity.this.gpsX = ((Double)args[0]).intValue();
                AirCannonBlockEntity.this.gpsY = ((Double)args[1]).intValue();
                AirCannonBlockEntity.this.gpsZ = ((Double)args[2]).intValue();
                AirCannonBlockEntity.this.updateDestination();
                return new Object[]{AirCannonBlockEntity.this.coordWithinReach};
            }
        });
        registry.registerLuaMethod(new LuaMethod("fire"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{AirCannonBlockEntity.this.requestFire()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("firedOK"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{AirCannonBlockEntity.this.lastFireOK.get()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("isDoneTurning"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{AirCannonBlockEntity.this.doneTurning};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRotationAngle"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "angle (in degrees, 0 = north)");
                AirCannonBlockEntity.this.setTargetAngles(((Double)args[0]).floatValue(), AirCannonBlockEntity.this.targetHeightAngle);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setHeightAngle"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "angle (in degrees, 0 = horizontal)");
                AirCannonBlockEntity.this.setTargetAngles(AirCannonBlockEntity.this.targetRotationAngle, 90.0f - ((Double)args[0]).floatValue());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "true/false");
                AirCannonBlockEntity.this.externalControl = (Boolean)args[0];
                return null;
            }
        });
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public MutableComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.airCannon.fireUpon", new Object[0]);
    }

    private class AirCannonStackHandler
    extends BaseItemStackHandler {
        AirCannonStackHandler(BlockEntity te) {
            super(te, 2);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (slot == 1) {
                return itemStack.isEmpty() || itemStack.getItem() instanceof IPositionProvider;
            }
            return true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 1) {
                AirCannonBlockEntity.this.gpsSlotChanged = true;
            }
        }
    }
}

