/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryControllerBlockEntity;
import me.desht.pneumaticcraft.common.inventory.RefineryMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class RefineryOutputBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<RefineryOutputBlockEntity>,
IComparatorSupport,
ISerializableTanks,
MenuProvider,
IHeatExchangingTE {
    private RefineryControllerBlockEntity controllerTE = null;
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final IFluidHandler wrappedTank = new TankWrapper(this.outputTank);
    private final RedstoneController<RefineryOutputBlockEntity> rsController = new RedstoneController<RefineryOutputBlockEntity>(this);

    public RefineryOutputBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.REFINERY_OUTPUT.get(), pos, state);
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(@javax.annotation.Nullable Direction dir) {
        return dir == Direction.DOWN ? this.outputTank : this.wrappedTank;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.outputTank.tick();
    }

    @Override
    public int getComparatorValue() {
        return this.getRefineryController().map(RefineryControllerBlockEntity::getComparatorValue).orElse(0);
    }

    @Override
    public RedstoneController<RefineryOutputBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public int getRedstoneMode() {
        return this.getRefineryController().map(IRedstoneControl::getRedstoneMode).orElse(0);
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.OUTPUT_TANK.get(), this.outputTank);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return this.getRefineryController().map(c -> new RefineryMenu(windowId, inventory, c.getBlockPos())).orElse(null);
    }

    public Optional<RefineryControllerBlockEntity> getRefineryController() {
        if (this.controllerTE != null && this.controllerTE.isRemoved()) {
            this.controllerTE = null;
        }
        if (this.controllerTE == null) {
            Level level = this.nonNullLevel();
            BlockPos checkPos = this.worldPosition;
            while (level.getBlockState(checkPos.below()).getBlock() == ModBlocks.REFINERY_OUTPUT.get()) {
                checkPos = checkPos.below();
            }
            if (level.getBlockState(checkPos.below()).getBlock() == ModBlocks.REFINERY.get()) {
                this.controllerTE = (RefineryControllerBlockEntity)level.getBlockEntity(checkPos.below());
            } else {
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    if (level.getBlockState(checkPos.relative(d)).getBlock() != ModBlocks.REFINERY.get()) continue;
                    this.controllerTE = (RefineryControllerBlockEntity)level.getBlockEntity(checkPos.relative(d));
                }
            }
        }
        return Optional.ofNullable(this.controllerTE);
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    private record TankWrapper(SmartSyncTank wrapped) implements IFluidHandler
    {
        public int getTanks() {
            return this.wrapped.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.wrapped.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrapped.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.wrapped.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.wrapped.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.wrapped.drain(maxDrain, action);
        }
    }
}

