/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.heat;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.heat.CompressedIronBlockEntity;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class HeatSinkBlockEntity
extends CompressedIronBlockEntity {
    private final IHeatExchangerLogic airExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private double ambientTemp;

    public HeatSinkBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.HEAT_SINK.get(), pos, state);
        this.heatExchanger.setThermalCapacity(5.0);
        this.airExchanger.addConnectedExchanger(this.heatExchanger);
        this.airExchanger.setThermalResistance(14.0);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.nonNullLevel().isClientSide) {
            this.ambientTemp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)this.getLevel(), this.getBlockPos());
            this.airExchanger.setTemperature(this.ambientTemp);
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("airExchanger", (Tag)this.airExchanger.serializeNBT());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.airExchanger.deserializeNBT(tag.getCompound("airExchanger"));
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.airExchanger.tick();
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    public void onFannedByAirGrate() {
        this.heatExchanger.tick();
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return dir == null || dir == this.getRotation() ? super.getHeatExchanger(dir) : null;
    }
}

