/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.elevator;

import java.lang.ref.WeakReference;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ElevatorFrameBlockEntity
extends AbstractPneumaticCraftBlockEntity {
    private WeakReference<ElevatorBaseBlockEntity> baseRef = null;

    public ElevatorFrameBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ELEVATOR_FRAME.get(), pos, state);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    public ElevatorBaseBlockEntity getElevatorBase() {
        if (this.baseRef == null || this.baseRef.get() == null) {
            ElevatorBaseBlockEntity base = this.findElevatorBase();
            this.baseRef = new WeakReference<ElevatorBaseBlockEntity>(base);
        }
        return (ElevatorBaseBlockEntity)this.baseRef.get();
    }

    private ElevatorBaseBlockEntity findElevatorBase() {
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        pos1.set((Vec3i)this.worldPosition);
        Level level = this.nonNullLevel();
        do {
            pos1.move(Direction.DOWN);
            if (level.getBlockState((BlockPos)pos1).getBlock() != ModBlocks.ELEVATOR_BASE.get()) continue;
            return (ElevatorBaseBlockEntity)level.getBlockEntity((BlockPos)pos1);
        } while (level.getBlockState((BlockPos)pos1).getBlock() == ModBlocks.ELEVATOR_FRAME.get() && pos1.getY() > level.getMinBuildHeight());
        return null;
    }
}

