/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.Validate;

public class RedstoneController<T extends BlockEntity> {
    private static final Pattern RS_TAG_PATTERN = Pattern.compile("^redstone:(\\d+)$");
    private final T te;
    private final List<RedstoneMode<T>> modes;
    @GuiSynced
    private int currentMode;
    @GuiSynced
    private int currentRedstonePower = -1;

    public RedstoneController(T te) {
        this.te = te;
        this.modes = new StandardReceivingModes().modes();
    }

    public RedstoneController(T te, List<RedstoneMode<T>> modes) {
        Validate.isTrue((modes.size() >= 2 ? 1 : 0) != 0, (String)"must have at least 2 modes!", (Object[])new Object[0]);
        this.te = te;
        this.modes = modes;
    }

    public int getModeCount() {
        return this.modes.size();
    }

    public RedstoneMode<T> getModeDetails(int idx) {
        return this.modes.get(idx);
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int currentMode) {
        if (currentMode != this.currentMode && currentMode >= 0 && currentMode < this.modes.size()) {
            this.currentMode = currentMode;
            if (this.te != null) {
                ((IRedstoneControl)this.te).onRedstoneModeChanged(this.currentMode);
                this.te.setChanged();
            }
        }
    }

    public int getCurrentRedstonePower() {
        if (this.currentRedstonePower < 0) {
            this.updateRedstonePower();
        }
        return this.currentRedstonePower;
    }

    public boolean shouldRun() {
        return this.te != null && this.modes.get((int)this.currentMode).runPredicate.test(this.te);
    }

    public boolean shouldEmit() {
        return this.te != null && this.modes.get((int)this.currentMode).emissionPredicate.test(this.te);
    }

    public Saved save() {
        return new Saved(this.currentMode);
    }

    public void restore(Saved data) {
        this.currentMode = data.mode();
    }

    public boolean parseRedstoneMode(String tag) {
        Matcher m = RS_TAG_PATTERN.matcher(tag);
        if (m.matches() && m.groupCount() == 1) {
            this.setCurrentMode(Integer.parseInt(m.group(1)));
            return true;
        }
        return false;
    }

    public void updateRedstonePower() {
        if (this.te != null) {
            this.currentRedstonePower = Objects.requireNonNull(this.te.getLevel()).getBestNeighborSignal(this.te.getBlockPos());
        }
    }

    public boolean isEmitter() {
        return !this.modes.isEmpty() && this.modes.getFirst() instanceof EmittingRedstoneMode;
    }

    public Component getRedstoneTabTitle() {
        return this.te != null ? ((IRedstoneControl)this.te).getRedstoneTabTitle() : Component.empty();
    }

    public Component getDescription() {
        if (this.te != null) {
            return ((IRedstoneControl)this.te).getRedstoneTabTitle().append(": ").append((Component)PneumaticCraftUtils.xlate(this.modes.get(this.currentMode).getTranslationKey(), new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
        return Component.empty();
    }

    private static class StandardReceivingModes<T extends BlockEntity> {
        private StandardReceivingModes() {
        }

        public List<RedstoneMode<T>> modes() {
            return ImmutableList.of(new ReceivingRedstoneMode<BlockEntity>("standard.always", new ItemStack((ItemLike)Items.GUNPOWDER), te -> true), new ReceivingRedstoneMode<BlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.REDSTONE), te -> ((IRedstoneControl)te).getCurrentRedstonePower() > 0), new ReceivingRedstoneMode<BlockEntity>("standard.low_signal", new ItemStack((ItemLike)Items.REDSTONE_TORCH), te -> ((IRedstoneControl)te).getCurrentRedstonePower() == 0));
        }
    }

    public static abstract class RedstoneMode<T extends BlockEntity> {
        private final String id;
        private final Either<ItemStack, ResourceLocation> texture;
        private final Predicate<T> runPredicate;
        private final Predicate<T> emissionPredicate;

        public RedstoneMode(String id, ItemStack stackIcon, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this(id, (Either<ItemStack, ResourceLocation>)Either.left((Object)stackIcon), runPredicate, emissionPredicate);
        }

        public RedstoneMode(String id, ResourceLocation texture, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this(id, (Either<ItemStack, ResourceLocation>)Either.right((Object)texture), runPredicate, emissionPredicate);
        }

        private RedstoneMode(String id, Either<ItemStack, ResourceLocation> texture, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this.id = id;
            this.runPredicate = runPredicate;
            this.emissionPredicate = emissionPredicate;
            this.texture = texture;
        }

        public String getId() {
            return this.id;
        }

        public Either<ItemStack, ResourceLocation> getTexture() {
            return this.texture;
        }

        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.redstoneBehaviour." + this.id;
        }
    }

    public record Saved(int mode) {
        public static final Codec<Saved> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("mode").forGetter(Saved::mode)).apply((Applicative)builder, Saved::new));
        public static final StreamCodec<ByteBuf, Saved> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Saved::mode, Saved::new);
        public static final Saved DEFAULT = new Saved(0);

        public static Saved fromNBT(HolderLookup.Provider provider, CompoundTag tag) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().orElse(DEFAULT);
        }

        public Tag toNBT(HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }
    }

    public static class EmittingRedstoneMode<T extends BlockEntity>
    extends RedstoneMode<T> {
        public EmittingRedstoneMode(String id, ResourceLocation texture, Predicate<T> emissionPredicate) {
            super(id, texture, (T te) -> false, emissionPredicate);
        }

        public EmittingRedstoneMode(String id, ItemStack stackIcon, Predicate<T> emissionPredicate) {
            super(id, stackIcon, (T te) -> false, emissionPredicate);
        }
    }

    public static class ReceivingRedstoneMode<T extends BlockEntity>
    extends RedstoneMode<T> {
        public ReceivingRedstoneMode(String id, ResourceLocation texture, Predicate<T> runPredicate) {
            super(id, texture, runPredicate, (T t) -> false);
        }

        public ReceivingRedstoneMode(String id, ItemStack stackIcon, Predicate<T> runPredicate) {
            super(id, stackIcon, runPredicate, (T te) -> false);
        }
    }
}

