/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.EntityTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.EntityTrackOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.EntityTrackerHandler;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.util.entityfilter.EntityFilter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;

public class EntityTrackerClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<EntityTrackerHandler> {
    private static final int ENTITY_TRACK_THRESHOLD = 7;
    private static final float ENTITY_TRACKING_RANGE = 16.0f;
    private static final StatPanelLayout DEFAULT_STAT_LAYOUT = StatPanelLayout.expandsLeft(0.995f, 0.2f);
    private final Int2ObjectMap<RenderEntityTarget> targets = new Int2ObjectOpenHashMap();
    private IGuiAnimatedStat entityTrackInfo;
    @Nonnull
    private EntityFilter entityFilter = new EntityFilter("");

    public EntityTrackerClientHandler() {
        super(CommonUpgradeHandlers.entityTrackerHandler);
    }

    public static void addDroneToHudHandler(DroneEntity drone, BlockPos pos) {
        ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).getTargetsStream().filter(target -> target.entity == drone).forEach(target -> target.getDroneAIRenderer(drone).addBlackListEntry(drone.level(), pos));
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        EntityFilter newFilter;
        String filterStr;
        if (!isEnabled) {
            return;
        }
        int rangeUpgrades = armorHandler.getUpgradeCount(EquipmentSlot.HEAD, ModUpgrades.RANGE.get());
        Player player = armorHandler.getPlayer();
        ItemStack helmetStack = player.getItemBySlot(EquipmentSlot.HEAD);
        String string = filterStr = helmetStack.isEmpty() ? "" : PneumaticArmorItem.getEntityFilter(helmetStack);
        if (!this.entityFilter.toString().equals(filterStr) && (newFilter = EntityFilter.fromString(filterStr)) != null) {
            this.entityFilter = newFilter;
        }
        double entityTrackRange = 16.0f + (float)(rangeUpgrades * 16);
        AABB bbBox = EntityTrackerClientHandler.getAABBFromRange(player, rangeUpgrades);
        List entities = armorHandler.getPlayer().level().getEntitiesOfClass(Entity.class, bbBox, (Predicate)((Object)new EntityTrackerSelector(player, this.entityFilter, entityTrackRange)));
        for (Entity entity : entities) {
            RenderEntityTarget target = (RenderEntityTarget)this.targets.get(entity.getId());
            if (target != null) {
                target.ticksExisted = Math.abs(target.ticksExisted);
                continue;
            }
            this.targets.put(entity.getId(), (Object)new RenderEntityTarget(entity));
        }
        IntArrayList toRemove = new IntArrayList();
        this.targets.forEach((arg_0, arg_1) -> this.lambda$tickClient$2(player, entityTrackRange, (IntList)toRemove, arg_0, arg_1));
        toRemove.forEach(arg_0 -> this.targets.remove(arg_0));
        ArrayList<Component> text = new ArrayList<Component>();
        for (RenderEntityTarget target : this.targets.values()) {
            boolean wasNegative = target.ticksExisted < 0;
            target.ticksExisted += armorHandler.getSpeedFromUpgrades(EquipmentSlot.HEAD);
            if (target.ticksExisted >= 0 && wasNegative) {
                target.ticksExisted = -1;
            }
            target.tick();
            if (!target.isLookingAtTarget) continue;
            if (target.isInitialized()) {
                text.add((Component)target.entity.getDisplayName().copy().withStyle(ChatFormatting.GRAY));
                text.addAll(target.getEntityText());
                continue;
            }
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.acquiring", new Object[0]).withStyle(ChatFormatting.GRAY));
        }
        if (text.isEmpty()) {
            String f = this.entityFilter.toString();
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.entityFilter", new Object[0]).append(": " + (f.isEmpty() ? "-" : f)));
        }
        this.entityTrackInfo.setText(text);
    }

    static AABB getAABBFromRange(Player player, int rangeUpgrades) {
        double entityTrackRange = 16.0f + (float)(Math.min(5, rangeUpgrades) * 16);
        return new AABB(player.blockPosition()).inflate(entityTrackRange);
    }

    @Override
    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        this.targets.values().forEach(target -> target.render(matrixStack, buffer, partialTicks, this.targets.size() > 7));
    }

    @Override
    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public void reset() {
        this.targets.clear();
        this.entityTrackInfo = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new EntityTrackOptions(screen, this);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.entityTrackInfo == null) {
            ItemStack icon = ModUpgrades.ENTITY_TRACKER.get().getItemStack();
            this.entityTrackInfo = ClientArmorRegistry.getInstance().makeHUDStatPanel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.trackedEntities", new Object[0]), icon, this);
            this.entityTrackInfo.setMinimumContractedDimensions(0, 0);
            this.entityTrackInfo.setAutoLineWrap(false);
        }
        return this.entityTrackInfo;
    }

    @Override
    public StatPanelLayout getDefaultStatLayout() {
        return DEFAULT_STAT_LAYOUT;
    }

    public Stream<RenderEntityTarget> getTargetsStream() {
        return this.targets.values().stream();
    }

    public RenderEntityTarget getTargetForEntity(Entity entity) {
        return this.getTargetsStream().filter(target -> target.entity == entity).findFirst().orElse(null);
    }

    public void hack() {
        this.getTargetsStream().forEach(RenderEntityTarget::hack);
    }

    public void selectAsDebuggingTarget() {
        this.getTargetsStream().forEach(RenderEntityTarget::selectAsDebuggingTarget);
    }

    public boolean scroll(InputEvent.MouseScrollingEvent event) {
        return this.getTargetsStream().anyMatch(target -> target.scroll(event));
    }

    @Override
    public void onResolutionChanged() {
        this.entityTrackInfo = null;
    }

    @Override
    public void setOverlayColor(int color) {
        super.setOverlayColor(color);
        this.targets.values().forEach(target -> target.updateColor(color));
    }

    private /* synthetic */ void lambda$tickClient$2(Player player, double entityTrackRange, IntList toRemove, Integer entityId, RenderEntityTarget target) {
        if (!target.entity.isAlive() || (double)player.distanceTo(target.entity) > entityTrackRange + 5.0 || !this.entityFilter.test(target.entity)) {
            if (target.ticksExisted > 0) {
                target.ticksExisted = -60;
            } else if (target.ticksExisted == -1) {
                toRemove.add(entityId.intValue());
            }
        }
    }

    private static class EntityTrackerSelector
    extends StringFilterEntitySelector {
        private final Player player;
        private final double threshold;

        private EntityTrackerSelector(Player player, EntityFilter filter, double threshold) {
            this.player = player;
            this.threshold = threshold;
            this.setFilter(Collections.singletonList(filter));
        }

        public boolean test(Entity entity) {
            if (entity == this.player || !(entity instanceof LivingEntity) && !(entity instanceof HangingEntity) && !(entity instanceof AbstractMinecart) || !entity.isAlive() || (double)this.player.distanceTo(entity) > this.threshold) {
                return false;
            }
            EntityTrackEvent event = (EntityTrackEvent)NeoForge.EVENT_BUS.post((Event)new EntityTrackEvent(entity));
            return !event.isCanceled() && super.test((Object)entity);
        }
    }
}

