/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.CustomFakePlayer;
import com.darkere.crashutils.DataStructures.TileEntityData;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.Network.RemoveEntitiesMessage;
import com.darkere.crashutils.Network.RemoveEntityMessage;
import com.darkere.crashutils.Network.TeleportMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;

public class WorldUtils {
    public static List<ServerLevel> getWorldsFromDimensionArgument(CommandContext<CommandSourceStack> context) {
        ServerLevel world = null;
        try {
            world = DimensionArgument.getDimension(context, (String)"dim");
        }
        catch (CommandSyntaxException | IllegalArgumentException throwable) {
            // empty catch block
        }
        ArrayList<ServerLevel> worlds = new ArrayList<ServerLevel>();
        if (world == null) {
            ((CommandSourceStack)context.getSource()).getServer().getAllLevels().forEach(worlds::add);
        } else {
            worlds.add(world);
        }
        return worlds;
    }

    public static void teleportPlayer(Player player, Level startWorld, Level destWorld, BlockPos newPos) {
        if (player.getCommandSenderWorld().isClientSide()) {
            Network.sendToServer(new TeleportMessage((ResourceKey<Level>)startWorld.dimension(), (ResourceKey<Level>)destWorld.dimension(), newPos));
            return;
        }
        if (newPos.getY() == 0) {
            LevelChunk chunk = destWorld.getChunkAt(newPos);
            int y = chunk.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, newPos.getX(), newPos.getZ());
            newPos = new BlockPos(newPos.getX(), y, newPos.getZ());
        }
        player.teleportTo((ServerLevel)destWorld, (double)(newPos.getX() + 1), (double)newPos.getY(), (double)newPos.getZ(), Set.of(), player.getYRot(), player.getXRot());
    }

    public static boolean applyToPlayer(String playerName, MinecraftServer server, Consumer<ServerPlayer> consumer) {
        ServerPlayer player = server.getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            Optional profile = server.getProfileCache().get(playerName);
            if (profile.isEmpty()) {
                return false;
            }
            CustomFakePlayer fakePlayer = new CustomFakePlayer(server.getLevel(Level.OVERWORLD), (GameProfile)profile.get());
            Optional nbt = server.playerDataStorage.load((Player)fakePlayer);
            if (nbt.isEmpty()) {
                return false;
            }
            fakePlayer.load((CompoundTag)nbt.get());
            CuriosApi.getCuriosInventory((LivingEntity)fakePlayer);
            consumer.accept((ServerPlayer)fakePlayer);
            server.playerDataStorage.save((Player)fakePlayer);
        } else {
            consumer.accept(player);
        }
        return true;
    }

    public static BlockPos getChunkCenter(ChunkPos pos) {
        int x = pos.getMinBlockX() + 8;
        int z = pos.getMinBlockZ() + 8;
        return new BlockPos(x, 0, z);
    }

    public static void removeEntity(Level world, UUID id) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntityMessage((ResourceKey<Level>)world.dimension(), id, false, false));
            return;
        }
        Entity e = ((ServerLevel)world).getEntity(id);
        if (e == null) {
            return;
        }
        e.remove(Entity.RemovalReason.DISCARDED);
    }

    public static void removeEntityType(Level world, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, rl)) {
            return;
        }
        ArrayList runnables = new ArrayList();
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.dimension(), rl, ChunkPos.ZERO, false, force, true));
            return;
        }
        ((ServerLevel)world).getEntities().getAll().forEach(entity -> {
            ResourceLocation rl2 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (!Objects.equals(rl2, rl)) {
                return;
            }
            runnables.add(() -> entity.remove(Entity.RemovalReason.DISCARDED));
        });
        runnables.forEach(Runnable::run);
    }

    public static void removeEntitiesInChunk(Level world, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, pos, rl)) {
            return;
        }
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.dimension(), rl, pos, false, force, false));
            return;
        }
        Vec3 start = new Vec3((double)pos.getMinBlockX(), 0.0, (double)pos.getMinBlockZ());
        Vec3 end = new Vec3((double)pos.getMaxBlockX(), 255.0, (double)pos.getMaxBlockZ());
        world.getEntities((Entity)null, new AABB(start, end), entity -> Objects.equals(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()), rl)).forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
    }

    public static void removeTileEntity(Level world, UUID id, boolean force) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntityMessage((ResourceKey<Level>)world.dimension(), id, true, force));
            return;
        }
        CrashUtils.runNextTick(wld -> {
            if (force) {
                world.removeBlockEntity(TileEntityData.TEID.get(id).pos());
                world.removeBlock(TileEntityData.TEID.get(id).pos(), false);
            } else {
                world.removeBlockEntity(TileEntityData.TEID.get(id).pos());
            }
        });
    }

    public static void removeTileEntityType(Level level, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(level, rl)) {
            return;
        }
        if (level.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)level.dimension(), rl, ChunkPos.ZERO, true, force, true));
            return;
        }
        for (ChunkHolder chunk : ((ServerLevel)level).getChunkSource().chunkMap.getChunks()) {
            if (!chunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING)) continue;
            chunk.getTickingChunk().getBlockEntities().forEach((pos, e) -> {
                if (BlockEntityType.getKey((BlockEntityType)e.getType()).equals((Object)rl)) {
                    CrashUtils.runNextTick(wld -> {
                        if (force) {
                            level.removeBlockEntity(e.getBlockPos());
                            level.removeBlock(e.getBlockPos(), false);
                        } else {
                            level.removeBlockEntity(e.getBlockPos());
                        }
                    });
                }
            });
        }
    }

    public static void removeTileEntitiesInChunk(Level level, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(level, pos, rl)) {
            return;
        }
        if (level.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)level.dimension(), rl, pos, true, force, false));
            return;
        }
        Vec3 start = new Vec3((double)pos.getMinBlockX(), 0.0, (double)pos.getMinBlockZ());
        Vec3 end = new Vec3((double)pos.getMaxBlockX(), 255.0, (double)pos.getMaxBlockZ());
        level.blockEntityTickers.stream().filter(te -> Objects.equals(te.getType(), rl.toString()) && new AABB(start, end).contains(Vec3.atCenterOf((Vec3i)te.getPos()))).forEach(te -> CrashUtils.runNextTick(wld -> {
            if (force) {
                level.removeBlockEntity(te.getPos());
                level.removeBlock(te.getPos(), false);
            } else {
                level.removeBlockEntity(te.getPos());
            }
        }));
    }
}

