/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenEnderChestMessage(String playerName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenEnderChestMessage> TYPE = new CustomPacketPayload.Type(CrashUtils.ResourceLocation("openenderchestmessage"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenEnderChestMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, OpenEnderChestMessage::playerName, OpenEnderChestMessage::new);

    public static boolean handle(OpenEnderChestMessage data, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (player.getServer() == null || !player.hasPermissions(2)) {
            return true;
        }
        ServerPlayer otherPlayer = player.getServer().getPlayerList().getPlayerByName(data.playerName);
        if (otherPlayer == null) {
            Optional profile = player.getServer().getProfileCache().get(data.playerName);
            if (profile.isEmpty()) {
                CommandUtils.sendMessageToPlayer((Player)player, "Cannot find Player");
                return true;
            }
            otherPlayer = new FakePlayer(player.getServer().getLevel(Level.OVERWORLD), (GameProfile)profile.get());
            Optional nbt = player.getServer().playerDataStorage.load((Player)otherPlayer);
            if (nbt.isEmpty()) {
                CommandUtils.sendMessageToPlayer((Player)player, "Cannot load playerData");
                return true;
            }
            otherPlayer.load((CompoundTag)nbt.get());
        }
        ServerPlayer finalOtherPlayer = otherPlayer;
        player.openMenu(new MenuProvider(){
            final /* synthetic */ Player val$finalOtherPlayer;
            final /* synthetic */ ServerPlayer val$player;
            {
                this.val$finalOtherPlayer = player;
                this.val$player = serverPlayer;
            }

            public Component getDisplayName() {
                return this.val$finalOtherPlayer.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                return new ChestMenu(MenuType.GENERIC_9x3, id, this.val$player.getInventory(), (Container)this.val$finalOtherPlayer.getEnderChestInventory(), 3){

                    public void removed(Player p_75134_1_) {
                        super.removed(p_75134_1_);
                        val$player.getServer().playerDataStorage.save(val$finalOtherPlayer);
                    }

                    public boolean stillValid(Player p_75145_1_) {
                        return true;
                    }
                };
            }
        });
        return true;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

