/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public interface FileUtils {
    public static void removeTmpFiles(Path dir) {
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(".tmp")) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Error while deleting tmp files: ", (Throwable)e);
        }
    }

    public static void removeOldLogsFolder() {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)Paths.get("local", "crash_assistant", "logs").toFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Files.delete(Paths.get("logs", "crash_assistant", "latest.log"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashSet<Path> getModifiedFiles(Path dir, String extension) {
        HashSet<Path> filesFound = new HashSet<Path>();
        if (dir.toFile().exists()) {
            try {
                Files.list(dir).forEach(path -> {
                    String fileName = path.getFileName().toString();
                    if (fileName.endsWith(extension) && path.toFile().lastModified() >= Boot.parentStarted) {
                        filesFound.add((Path)path);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return filesFound;
    }

    public static boolean isCurseForgeEnv() {
        try {
            Path curseForgeDir = Paths.get("", new String[0]).toAbsolutePath().getParent().getParent();
            List curseForgeDirContents = Files.list(curseForgeDir).map(dirPath -> dirPath.getFileName().toString().toLowerCase()).collect(Collectors.toList());
            if (curseForgeDirContents.contains("instances") && curseForgeDirContents.contains("install")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean folderNLevelsUpperNameContains(int levels, String sToCheck) {
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < levels; ++i) {
            path.append("../");
        }
        Path fileName = Paths.get(path.toString(), new String[0]).toAbsolutePath().normalize().getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().contains(sToCheck);
    }
}

