/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.electric_motor;

import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CALang;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ElectricMotorBlockEntity
extends GeneratingKineticBlockEntity {
    protected float motorSpeed;
    protected ScrollValueBehaviour generatedSpeed;
    protected final InternalEnergyStorage energy = new InternalEnergyStorage((Integer)CommonConfig.ELECTRIC_MOTOR_CAPACITY.get(), (Integer)CommonConfig.ELECTRIC_MOTOR_MAX_INPUT.get(), 0);
    private final IEnergyStorage capability = this.energy;
    private boolean cc_update_rpm = false;
    private float cc_new_rpm = 32.0f;
    private boolean active = false;
    boolean first = true;

    public ElectricMotorBlockEntity(BlockEntityType<? extends ElectricMotorBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CABlockEntities.ELECTRIC_MOTOR.get(), (be, context) -> be.capability);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.getValue((Property)ElectricMotorBlock.FACING) == side.getOpposite());
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)CreateLang.translateDirect((String)"generic.speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-((Integer)CommonConfig.ELECTRIC_MOTOR_RPM_RANGE.get()).intValue(), ((Integer)CommonConfig.ELECTRIC_MOTOR_RPM_RANGE.get()).intValue());
        this.generatedSpeed.value = 32;
        this.generatedSpeed.withCallback(this::updateGeneratedRotation);
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        int current = context.currentValue;
        int step = 1;
        if (!context.shift) {
            int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
            if (magnitude >= 4) {
                step *= 4;
            }
            if (magnitude >= 32) {
                step *= 4;
            }
            if (magnitude >= 128) {
                step *= 4;
            }
        }
        return step;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)((Integer)CommonConfig.MAX_STRESS.get()).intValue() / 256.0f;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.energy.consumption").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
        CALang.builder().add(Component.literal((String)(" " + Util.format(ElectricMotorBlockEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue())) + "\u26a1/t ")).withStyle(ChatFormatting.AQUA).append((Component)CreateLang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).withStyle(ChatFormatting.DARK_GRAY))).forGoggles(tooltip);
        return true;
    }

    public void updateGeneratedRotation(int rpm) {
        this.motorSpeed = rpm;
        super.updateGeneratedRotation();
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!CABlocks.ELECTRIC_MOTOR.has(this.getBlockState())) {
            return 0.0f;
        }
        return ElectricMotorBlockEntity.convertToDirection((float)(this.active ? this.motorSpeed : 0.0f), (Direction)((Direction)this.getBlockState().getValue((Property)ElectricMotorBlock.FACING)));
    }

    protected Block getStressConfigKey() {
        return (Block)CABlocks.ELECTRIC_MOTOR.get();
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.energy.read(tag);
        this.active = tag.getBoolean("active");
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        this.energy.write(tag);
        tag.putBoolean("active", this.active);
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public static int getEnergyConsumptionRate(float rpm) {
        return Math.abs(rpm) > 0.0f ? (int)Math.max((double)((Integer)CommonConfig.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0), (double)((Integer)CommonConfig.ELECTRIC_MOTOR_MINIMUM_CONSUMPTION.get()).intValue()) : 0;
    }

    public void tick() {
        super.tick();
        if (this.first) {
            this.motorSpeed = this.generatedSpeed.getValue();
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm) {
            this.generatedSpeed.setValue(Math.round(this.cc_new_rpm));
            this.motorSpeed = this.cc_new_rpm;
            this.cc_update_rpm = false;
            this.updateGeneratedRotation();
        }
        if (this.level.isClientSide()) {
            return;
        }
        int con = ElectricMotorBlockEntity.getEnergyConsumptionRate(this.motorSpeed);
        if (!this.active) {
            if (this.energy.getEnergyStored() > con * 2 && !((Boolean)this.getBlockState().getValue((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = true;
                this.updateGeneratedRotation();
            }
        } else {
            int ext = this.energy.internalConsumeEnergy(con);
            if (ext < con || ((Boolean)this.getBlockState().getValue((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = false;
                this.updateGeneratedRotation();
            }
        }
    }

    public void tickAudio() {
        super.tickAudio();
        if (!this.active) {
            return;
        }
        if (((Boolean)CommonConfig.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play(CASoundScapes.AmbienceGroup.DYNAMO, this.worldPosition, 1.0f);
        }
    }

    public static float getDurationAngle(float deg, float initialProgress, float speed) {
        speed = Math.abs(speed);
        deg = Math.abs(deg);
        if (speed < 0.1f) {
            return 0.0f;
        }
        double degreesPerTick = speed * 360.0f / 60.0f / 20.0f;
        return (float)((double)((1.0f - initialProgress) * deg) / degreesPerTick + 1.0);
    }

    public static float getDurationDistance(float dis, float initialProgress, float speed) {
        speed = Math.abs(speed);
        dis = Math.abs(dis);
        if (speed < 0.1f) {
            return 0.0f;
        }
        double metersPerTick = speed / 512.0f;
        return (float)((double)((1.0f - initialProgress) * dis) / metersPerTick);
    }

    public boolean setRPM(float rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, (float)((Integer)CommonConfig.ELECTRIC_MOTOR_RPM_RANGE.get()).intValue()), (float)(-((Integer)CommonConfig.ELECTRIC_MOTOR_RPM_RANGE.get()).intValue()));
        this.cc_update_rpm = true;
        return true;
    }

    public float getRPM() {
        return this.motorSpeed;
    }

    public int getGeneratedStress() {
        return (int)this.calculateAddedStressCapacity();
    }

    public int getEnergyConsumption() {
        return ElectricMotorBlockEntity.getEnergyConsumptionRate(this.motorSpeed);
    }

    public boolean isPoweredState() {
        return (Boolean)this.getBlockState().getValue((Property)TeslaCoilBlock.POWERED);
    }
}

