/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jade;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.CommonProxy;

public class MercuryFluxEnergyProvider
implements IServerExtensionProvider<CompoundTag>,
IClientExtensionProvider<CompoundTag, EnergyView> {
    public static final ResourceLocation ID = Theurgy.loc("mercury_flux");
    private static final MercuryFluxEnergyProvider instance = new MercuryFluxEnergyProvider();

    public static MercuryFluxEnergyProvider get() {
        return instance;
    }

    @Nullable
    public static List<ViewGroup<CompoundTag>> wrapMercuryFluxStorage(Accessor<?> accessor) {
        MercuryFluxStorage storage = (MercuryFluxStorage)CommonProxy.getDefaultStorage(accessor, CapabilityRegistry.MERCURY_FLUX_HANDLER, null);
        if (storage != null) {
            ViewGroup group = new ViewGroup(List.of(EnergyView.of((long)storage.getEnergyStored(), (long)storage.getMaxEnergyStored())));
            group.getExtraData().putString("Unit", "MF");
            return List.of(group);
        }
        return null;
    }

    public List<ClientViewGroup<EnergyView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return groups.stream().map($ -> {
            String unit = $.getExtraData().getString("Unit");
            return new ClientViewGroup($.views.stream().map(tag -> EnergyView.read((CompoundTag)tag, (String)unit)).filter(Objects::nonNull).toList());
        }).toList();
    }

    public ResourceLocation getUid() {
        return ID;
    }

    @Nullable
    public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor) {
        return MercuryFluxEnergyProvider.wrapMercuryFluxStorage(accessor);
    }

    public boolean shouldRequestData(Accessor<?> accessor) {
        return MercuryFluxEnergyProvider.hasDefaultMercuryFluxStorage(accessor);
    }

    public static boolean hasDefaultMercuryFluxStorage(Accessor<?> accessor) {
        return CommonProxy.hasDefaultStorage(accessor, CapabilityRegistry.MERCURY_FLUX_HANDLER, null);
    }
}

