/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.emi;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.content.recipe.CalcinationRecipe;
import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.content.recipe.DistillationRecipe;
import com.klikli_dev.theurgy.content.recipe.FermentationRecipe;
import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.content.recipe.ReformationRecipe;
import com.klikli_dev.theurgy.integration.emi.AccumulationEmiRecipe;
import com.klikli_dev.theurgy.integration.emi.CalcinationEmiRecipe;
import com.klikli_dev.theurgy.integration.emi.DigestionEmiRecipe;
import com.klikli_dev.theurgy.integration.emi.DistillationEmiRecipe;
import com.klikli_dev.theurgy.integration.emi.FermentationEmiRecipe;
import com.klikli_dev.theurgy.integration.emi.IncubationEmiRecipe;
import com.klikli_dev.theurgy.integration.emi.LiquefactionEmiRecipe;
import com.klikli_dev.theurgy.integration.emi.ReformationEmiRecipe;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredHolder;

@EmiEntrypoint
public class EmiPlugin
implements dev.emi.emi.api.EmiPlugin {
    public static final EmiStack ACCUMULATION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get()));
    public static final EmiRecipeCategory ACCUMULATION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.ACCUMULATION.getId(), (EmiRenderable)ACCUMULATION_ICON);
    public static final EmiStack CALCINATION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.CALCINATION_OVEN.get()));
    public static final EmiRecipeCategory CALCINATION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.CALCINATION.getId(), (EmiRenderable)CALCINATION_ICON);
    public static final EmiStack DIGESTION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.DIGESTION_VAT.get()));
    public static final EmiRecipeCategory DIGESTION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.DIGESTION.getId(), (EmiRenderable)DIGESTION_ICON);
    public static final EmiStack DISTILLATION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.DISTILLER.get()));
    public static final EmiRecipeCategory DISTILLATION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.DISTILLATION.getId(), (EmiRenderable)DISTILLATION_ICON);
    public static final EmiStack FERMENTATION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.FERMENTATION_VAT.get()));
    public static final EmiRecipeCategory FERMENTATION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.FERMENTATION.getId(), (EmiRenderable)FERMENTATION_ICON);
    public static final EmiStack INCUBATION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.INCUBATOR.get()));
    public static final EmiRecipeCategory INCUBATION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.INCUBATION.getId(), (EmiRenderable)INCUBATION_ICON);
    public static final EmiStack LIQUEFACTION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.LIQUEFACTION_CAULDRON.get()));
    public static final EmiRecipeCategory LIQUEFACTION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.LIQUEFACTION.getId(), (EmiRenderable)LIQUEFACTION_ICON);
    public static final EmiStack REFORMATION_ICON = EmiStack.of((ItemLike)((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get()));
    public static final EmiRecipeCategory REFORMATION_CATEGORY = new EmiRecipeCategory(RecipeTypeRegistry.REFORMATION.getId(), (EmiRenderable)REFORMATION_ICON);

    public void register(EmiRegistry registry) {
        registry.addCategory(ACCUMULATION_CATEGORY);
        registry.addWorkstation(ACCUMULATION_CATEGORY, (EmiIngredient)ACCUMULATION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.ACCUMULATION.get())) {
            registry.addRecipe((EmiRecipe)new AccumulationEmiRecipe((RecipeHolder<AccumulationRecipe>)recipe));
        }
        registry.addCategory(CALCINATION_CATEGORY);
        registry.addWorkstation(CALCINATION_CATEGORY, (EmiIngredient)CALCINATION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.CALCINATION.get())) {
            registry.addRecipe((EmiRecipe)new CalcinationEmiRecipe((RecipeHolder<CalcinationRecipe>)recipe));
        }
        registry.addCategory(DIGESTION_CATEGORY);
        registry.addWorkstation(DIGESTION_CATEGORY, (EmiIngredient)DIGESTION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.DIGESTION.get())) {
            registry.addRecipe((EmiRecipe)new DigestionEmiRecipe((RecipeHolder<DigestionRecipe>)recipe));
        }
        registry.addCategory(DISTILLATION_CATEGORY);
        registry.addWorkstation(DISTILLATION_CATEGORY, (EmiIngredient)DISTILLATION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.DISTILLATION.get())) {
            registry.addRecipe((EmiRecipe)new DistillationEmiRecipe((RecipeHolder<DistillationRecipe>)recipe));
        }
        registry.addCategory(FERMENTATION_CATEGORY);
        registry.addWorkstation(FERMENTATION_CATEGORY, (EmiIngredient)FERMENTATION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.FERMENTATION.get())) {
            registry.addRecipe((EmiRecipe)new FermentationEmiRecipe((RecipeHolder<FermentationRecipe>)recipe));
        }
        registry.addCategory(INCUBATION_CATEGORY);
        registry.addWorkstation(INCUBATION_CATEGORY, (EmiIngredient)INCUBATION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.INCUBATION.get())) {
            registry.addRecipe((EmiRecipe)new IncubationEmiRecipe((RecipeHolder<IncubationRecipe>)recipe));
        }
        registry.addCategory(LIQUEFACTION_CATEGORY);
        registry.addWorkstation(LIQUEFACTION_CATEGORY, (EmiIngredient)LIQUEFACTION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get())) {
            registry.addRecipe((EmiRecipe)new LiquefactionEmiRecipe((RecipeHolder<LiquefactionRecipe>)recipe));
        }
        registry.addCategory(REFORMATION_CATEGORY);
        registry.addWorkstation(REFORMATION_CATEGORY, (EmiIngredient)REFORMATION_ICON);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.REFORMATION.get())) {
            registry.addRecipe((EmiRecipe)new ReformationEmiRecipe((RecipeHolder<ReformationRecipe>)recipe));
        }
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)Items.LAVA_BUCKET)), List.of(Component.translatable((String)"theurgy.emi.header").withStyle(ChatFormatting.BOLD), Component.translatable((String)"theurgy.emi.info.lava_bucket")), Theurgy.loc("emi/laval_bucket")));
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)Items.WATER_BUCKET)), List.of(Component.translatable((String)"theurgy.emi.header").withStyle(ChatFormatting.BOLD), Component.translatable((String)"theurgy.emi.info.water_bucket")), Theurgy.loc("emi/water_bucket")));
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of(ItemRegistry.SAL_AMMONIAC_BUCKET)), List.of(Component.translatable((String)"theurgy.emi.header").withStyle(ChatFormatting.BOLD), Component.translatable((String)"theurgy.emi.info.sal_ammoniac_bucket")), Theurgy.loc("emi/sal_ammoniac_bucket")));
    }

    public void initialize(EmiInitRegistry registry) {
        RecipeManager recipeManager = EmiPlugin.getRecipeManager();
        List liquefactionRecipes = recipeManager.getAllRecipesFor((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get());
        List<EmiStack> sulfursWithoutRecipe = SulfurRegistry.SULFURS.getEntries().stream().map(DeferredHolder::get).map(AlchemicalSulfurItem.class::cast).filter(sulfur -> liquefactionRecipes.stream().noneMatch(r -> ((LiquefactionRecipe)r.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY) != null && ((LiquefactionRecipe)r.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem() == sulfur)).map(EmiStack::of).toList();
        sulfursWithoutRecipe.forEach(arg_0 -> ((EmiInitRegistry)registry).disableStack(arg_0));
    }

    public static RecipeManager getRecipeManager() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return DistHelper.getRecipeManager();
        }
        return null;
    }

    public static class DistHelper {
        public static RecipeManager getRecipeManager() {
            return Minecraft.getInstance().level.getRecipeManager();
        }
    }
}

