/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.recipe.result.ItemRecipeResult;
import com.klikli_dev.theurgy.content.recipe.result.RecipeResult;
import com.klikli_dev.theurgy.content.recipe.result.TagRecipeResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;

public abstract class JsonRecipeProvider
implements DataProvider {
    protected final PackOutput.PathProvider recipePathProvider;
    protected String modid;
    protected BiConsumer<ResourceLocation, JsonObject> recipeConsumer;

    public JsonRecipeProvider(PackOutput packOutput, String modid) {
        this(packOutput, modid, "");
    }

    public JsonRecipeProvider(PackOutput packOutput, String modid, String recipeSubPath) {
        this.recipePathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "recipe/" + recipeSubPath);
        this.modid = modid;
    }

    protected String name(ItemStack item) {
        return this.name((ItemLike)item.getItem());
    }

    protected String name(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    protected String name(TagKey<Item> tag) {
        return tag.location().getPath().replace('/', '_');
    }

    protected String name(List<TagKey<Item>> tags) {
        return tags.stream().distinct().map(this::name).reduce("", (a, b) -> a + "_and_" + b).replaceFirst("_and_", "");
    }

    public ResourceLocation locFor(TagKey<Item> tag) {
        return tag.location();
    }

    public ResourceLocation locFor(ItemLike itemLike) {
        return BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem());
    }

    public ResourceLocation locFor(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public TagKey<Item> tag(String tag) {
        return this.tag(ResourceLocation.parse((String)tag));
    }

    public TagKey<Item> tag(ResourceLocation tag) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag);
    }

    public ResourceLocation modLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)name);
    }

    public ResourceLocation mcLoc(String name) {
        return ResourceLocation.parse((String)name);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
        HashSet set = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        this.recipeConsumer = (id, recipe) -> {
            if (!recipe.has("category")) {
                recipe.addProperty("category", CraftingBookCategory.MISC.getSerializedName());
            }
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(id));
            }
            futures.add(DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)recipe, (Path)this.recipePathProvider.json(id)));
        };
        this.buildRecipes(this.recipeConsumer);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public abstract void buildRecipes(BiConsumer<ResourceLocation, JsonObject> var1);

    protected static abstract class RecipeBuilder<T extends RecipeBuilder<T>> {
        protected JsonObject recipe = new JsonObject();

        protected RecipeBuilder(Holder<RecipeType<?>> type) {
            this.recipe.addProperty("type", ((ResourceKey)type.unwrapKey().get()).location().toString());
        }

        public T getThis() {
            return (T)this;
        }

        public T time(int time) {
            this.recipe.addProperty("time", (Number)time);
            return this.getThis();
        }

        public T result(ItemStack result) {
            return this.result("result", result);
        }

        public T result(String propertyName, ItemStack result) {
            return this.result(propertyName, new ItemRecipeResult(result));
        }

        public T result(RecipeResult result) {
            return this.result("result", result);
        }

        public T result(String propertyName, RecipeResult result) {
            this.recipe.add(propertyName, (JsonElement)RecipeResult.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)result).getOrThrow());
            if (result instanceof TagRecipeResult) {
                TagRecipeResult tagRecipeResult = (TagRecipeResult)result;
                this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tagRecipeResult.tag().location().toString())));
            }
            return this.getThis();
        }

        public T result(FluidStack result) {
            return this.result("result", result);
        }

        public T result(String propertyName, FluidStack result) {
            this.recipe.add(propertyName, (JsonElement)FluidStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)result).getOrThrow());
            return this.getThis();
        }

        public T ingredient(TagKey<Item> tag) {
            return this.ingredient("ingredient", tag);
        }

        public T sizedIngredient(TagKey<Item> tag, int count) {
            return this.sizedIngredient("ingredient", tag, count);
        }

        public T sizedIngredient(ItemLike item, int count) {
            return this.sizedIngredient("ingredient", item, count);
        }

        public T ingredient(String propertyName, TagKey<Item> tag) {
            this.recipe.add(propertyName, (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)Ingredient.of(tag)).getOrThrow());
            this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tag.location().toString())));
            return this.getThis();
        }

        public T ingredient(ItemLike item) {
            return this.ingredient("ingredient", item);
        }

        public T ingredient(String propertyName, ItemLike item) {
            return this.ingredient(propertyName, Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }

        public T ingredient(String propertyName, Ingredient ingredient) {
            this.recipe.add(propertyName, (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient).getOrThrow());
            return this.getThis();
        }

        public T sizedIngredient(String propertyName, TagKey<Item> item, int amount) {
            this.recipe.add(propertyName, (JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of(item, (int)amount)).getOrThrow());
            this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(item.location().toString())));
            return this.getThis();
        }

        public T sizedIngredient(String propertyName, ItemLike item, int amount) {
            this.recipe.add(propertyName, (JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of((ItemLike)item, (int)amount)).getOrThrow());
            return this.getThis();
        }

        public T sizedFluidIngredient(String propertyName, TagKey<Fluid> fluid, int amount) {
            this.recipe.add(propertyName, (JsonElement)SizedFluidIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedFluidIngredient.of(fluid, (int)amount)).getOrThrow());
            return this.getThis();
        }

        public T sizedFluidIngredient(String propertyName, Fluid fluid, int amount) {
            this.recipe.add(propertyName, (JsonElement)SizedFluidIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedFluidIngredient.of((Fluid)fluid, (int)amount)).getOrThrow());
            return this.getThis();
        }

        public T fluidIngredient(String propertyName, Fluid fluid) {
            this.recipe.add(propertyName, (JsonElement)FluidIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)FluidIngredient.of((Fluid[])new Fluid[]{fluid})).getOrThrow());
            return this.getThis();
        }

        public T ingredient(String propertyName, Item item) {
            return this.ingredient(propertyName, (Holder<Item>)item.builtInRegistryHolder());
        }

        public T ingredient(String propertyName, Holder<Item> itemHolder) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ((ResourceKey)itemHolder.unwrapKey().get()).location().toString());
            this.recipe.add(propertyName, (JsonElement)jsonobject);
            return this.getThis();
        }

        public T condition(ICondition condition) {
            if (!this.recipe.has("neoforge:conditions")) {
                this.recipe.add("neoforge:conditions", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("neoforge:conditions").add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow());
            return this.getThis();
        }

        public JsonObject build() {
            if (!this.recipe.has("category")) {
                this.recipe.addProperty("category", CraftingBookCategory.MISC.getSerializedName());
            }
            return this.recipe;
        }
    }
}

