/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.datagen.book.TheurgyBookProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DivinationRodEntryProvider
extends CategoryProvider {
    public DivinationRodEntryProvider(TheurgyBookProvider parent, CategoryEntryMap entryMap) {
        super((ModonomiconProviderBase)parent);
        this.entryMap = entryMap;
    }

    public TheurgyBookProvider parent() {
        return (TheurgyBookProvider)this.parent;
    }

    protected String[] generateEntryMap() {
        throw new UnsupportedOperationException("This is a dummy provider to help generate entries, it should not be used to generate a Category.");
    }

    protected void generateEntries() {
        throw new UnsupportedOperationException("This is a dummy provider to help generate entries, it should not be used to generate a Category.");
    }

    protected String categoryName() {
        return "";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create((ItemLike)Items.BARRIER);
    }

    public String categoryId() {
        return "dummy";
    }

    public BookCategoryModel generate() {
        throw new UnsupportedOperationException("This is a dummy provider to help generate entries, it should not be used to generate a Category.");
    }

    protected BookEntryModel entry() {
        BookEntryModel entry = BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription());
        return entry;
    }

    protected BookEntryModel entry(char location) {
        return this.entry().withLocation(this.entryMap().get(Character.valueOf(location)));
    }

    public BookEntryModel aboutDivinationRods(char location) {
        this.context().entry("about_divination_rods");
        this.add(this.context().entryName(), "About Divination Rods");
        this.add(this.context().entryDescription(), "An Introduction to Ore-Finding");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.add(this.context().pageTitle(), "About Divination Rods");
        this.add(this.context().pageText(), "Divination Rods, also known as Dowsing Rods, are a valuable instrument used to locate ores and other valuable blocks. In order to show the location of a block, it must first be \"attuned\" to it.\n");
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.add(this.context().pageTitle(), "Rod Attunement");
        this.add(this.context().pageText(), "There are two methods of attuning, depending on the type of rod: by *crafting* a rod with the []($PURPLE)alchemical sulfur[](#) of the desired block, or by *using* a rod on the desired block.\n\\\n\\\nAttuning a rod to a block will cause it to point towards the nearest block of that type.\n");
        this.context().page("sulfur_attuned_rods");
        BookTextPageModel sulfurAttunedRods = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.add(this.context().pageTitle(), "Pre-Attuned Rods");
        this.add(this.context().pageText(), "Pre-Attuned rods, those that are crafted with alchemical sulfur, are more stable, and thus have a much higher durability, but require more effort to craft.\n\\\n\\\nResearch {0} (specifically, *Liquefaction*) to continue on this path.\n", new Object[]{this.entryLink("Spagyrics", "getting_started", "spagyrics")});
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.add(this.context().pageTitle(), "Usage");
        this.add(this.context().pageText(), "- **Shift-Click** a block to attune the rod to it (unless it is pre-attuned).\n- **Right-Click and hold** to let the rod search for blocks.\n- **Right-Click without holding** after a successful search will let the rod show the last found block without consuming durability.\n");
        this.context().page("usage2");
        BookTextPageModel usage2 = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.add(this.context().pageTitle(), "Usage");
        this.add(this.context().pageText(), "The rod will indicate that it found a block by *changing color* to be partially or fully purple, and by emitting a *glowing ball* that will fly towards the block, when right-clicked without holding.\n");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, intro2, sulfurAttunedRods, usage, usage2});
    }

    public BookEntryModel t1DivinationRodEntry(char location) {
        this.context().entry("t1_divination_rod");
        this.add(this.context().entryName(), "The Glass Divination Rod");
        this.add(this.context().entryDescription(), "A basic attunable rod for locating abundant and common ores.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "This divination rod is the most basic variant of attunable rods. It does not require Alchemical Sulfur and can be attuned to a variety of blocks by using it on them, even after it has previously been attuned. However, it has a lower durability than pre-attuned rods.\n");
        this.context().page("supported_blocks");
        BookTextPageModel supportedBlocks = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.add(this.context().pageTitle(), "Attunable Materials");
        this.add(this.context().pageText(), "Rods can be attuned to a wide variety of useful blocks, including various types of ores and wood. Basic divination rods will be sufficient to locate common ores such as {0} or {1}, but more rare and precious materials such as {2} and {3} will require a higher tier rod to detect.\n", new Object[]{this.itemLink("iron", (ItemLike)Items.IRON_ORE), this.itemLink("coal", (ItemLike)Items.COAL_ORE), this.itemLink("gold", (ItemLike)Items.GOLD_ORE), this.itemLink("diamonds", (ItemLike)Items.DIAMOND_ORE)});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/divination_rod_t1"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "The most basic tier of divination rods, brittle and limited in it's application, but powerful nonetheless.\n");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, supportedBlocks, recipe});
    }

    public BookEntryModel abundantAndCommonSulfurAttunedDivinationRodEntry(char location) {
        this.context().entry("abundant_and_common_sulfur_attuned_divination_rod");
        this.add(this.context().entryName(), "Basic Sulfur-Attuned Divination Rods");
        this.add(this.context().entryDescription(), "Pre-attuned rods for locating abundant and common ores.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get(), (ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "This divination rod is the most basic variant of pre-attuned rod. While it cannot be attuned to a new block after crafting, it has a much higher durability, and is generally more convenient to use.\n");
        this.context().page("sulfur");
        BookTextPageModel sulfur = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.add(this.context().pageTitle(), "Sulfur");
        this.add(this.context().pageText(), "To obtain sulfur for crafting this rod you first need to obtain an ore, ingot or gem of the type of material you want the rod to be attuned to. Then, you need to obtain it''s sulfur by melting it down in a {0}.\n", new Object[]{this.entryLink("Liquefaction Cauldron", "apparatus", "liquefaction_cauldron")});
        this.context().page("recipe_abundant");
        BookCraftingRecipePageModel recipe_abundant = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/sulfur_attuned_divination_rod_abundant"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "A rod pre-attuned to abundant ores, such as {0} or {1}.\n", new Object[]{this.itemLink("copper", (ItemLike)Items.COPPER_ORE), this.itemLink("coal", (ItemLike)Items.COAL_ORE)});
        this.context().page("recipe_common");
        BookCraftingRecipePageModel recipe_common = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/sulfur_attuned_divination_rod_common"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "A rod pre-attuned to common ores, such as {0} or {1}.\n", new Object[]{this.itemLink("iron", (ItemLike)Items.IRON_ORE), this.itemLink("lapis", (ItemLike)Items.LAPIS_ORE)});
        return this.entry(location).withIcon((ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, sulfur, recipe_abundant, recipe_common});
    }

    public BookEntryModel amethystDivinationRodEntry(char location) {
        this.context().entry("amethyst_divination_rod");
        this.add(this.context().entryName(), "Amethyst Divination Rod");
        this.add(this.context().entryDescription(), "A pre-attuned rod to find budding amethyst blocks.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.AMETHYST_DIVINATION_ROD.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "Crystals are especially useful for attuning divination rods, and many more advanced rod designs require {0} specifically. This rod is pre-attuned to locate budding amethyst blocks to make it easier to obtain these helpful crystals.\n", new Object[]{this.itemLink("amethyst shards", (ItemLike)Items.AMETHYST_SHARD)});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/amethyst_divination_rod"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "A pre-attuned rod that only finds {0}.\n", new Object[]{this.itemLink("amethyst", (ItemLike)Items.BUDDING_AMETHYST)});
        return this.entry(location).withIcon((ItemLike)ItemRegistry.AMETHYST_DIVINATION_ROD.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, recipe});
    }

    public BookEntryModel t2DivinationRodEntry(char location) {
        this.context().entry("t2_divination_rod");
        this.add(this.context().entryName(), "The Iron Divination Rod");
        this.add(this.context().entryDescription(), "An improved attunable rod for locating rare ores.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T2.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "An improved attunable divination rod to locate higher tier ores, such as {0}.\n", new Object[]{this.itemLink("gold", (ItemLike)Items.GOLD_ORE)});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/divination_rod_t2"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "An improved attunable divination rod, more durable and broader in it's application.\n");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T2.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, recipe});
    }

    public BookEntryModel t3DivinationRodEntry(char location) {
        this.context().entry("t3_divination_rod");
        this.add(this.context().entryName(), "The Diamond Divination Rod");
        this.add(this.context().entryDescription(), "A superior-grade attunable rod for locating precious ores.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T3.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "A further improved attunable divination rod to locate high tier ores, such as {0}.\n", new Object[]{this.itemLink("diamond", (ItemLike)Items.DIAMOND_ORE)});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/divination_rod_t3"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "A further improved attunable divination rod, much more durable and able to detect most ores.\n");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T3.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, recipe});
    }

    public BookEntryModel t4DivinationRodEntry(char location) {
        this.context().entry("t4_divination_rod");
        this.add(this.context().entryName(), "The Netherite Divination Rod");
        this.add(this.context().entryDescription(), "A very high durability attunable rod for locating precious ores.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T4.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "The very high durability attunable divination rod to locate ores of any tier, such as {0}.\n", new Object[]{this.itemLink("diamond", (ItemLike)Items.DIAMOND_ORE)});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/divination_rod_t4"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "The highest tier attunable divination rod, incredibly durable and able to detect all ores.\n");
        return this.entry(location).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T4.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, recipe});
    }

    public BookEntryModel rareSulfurAttunedDivinationRodEntry(char location) {
        this.context().entry("rare_sulfur_attuned_divination_rod");
        this.add(this.context().entryName(), "Sulfur-Attuned Divination Rods for Rare Materials");
        this.add(this.context().entryDescription(), "An improved design of Sulfur-Attuned Divination rods, allowing to locate rare ores.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "This divination rod is an improved variant of pre-attuned rod that is more durable allows to locate rare ores, such as {0}.\n", new Object[]{this.itemLink("gold", (ItemLike)Items.GOLD_ORE)});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/sulfur_attuned_divination_rod_rare"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "A rod pre-attuned to rare ores, such as {0}.\n", new Object[]{this.itemLink("gold", (ItemLike)Items.GOLD_ORE)});
        return this.entry(location).withIcon((ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, recipe});
    }

    public BookEntryModel preciousSulfurAttunedDivinationRodEntry(char location) {
        this.context().entry("precious_sulfur_attuned_divination_rod");
        this.add(this.context().entryName(), "Sulfur-Attuned Divination Rods for Precious Materials");
        this.add(this.context().entryDescription(), "An intricately crafted Sulfur-Attuned Divination rod, allowing to locate precious ores.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get()})).withText(this.context().pageText());
        this.add(this.context().pageText(), "This divination rod is the most powerful variant of pre-attuned rod, it is highly durable and allows to locate precious ores, such as {0}.\n", new Object[]{this.itemLink("diamond", (ItemLike)Items.DIAMOND_ORE)});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/sulfur_attuned_divination_rod_precious"))).withText(this.context().pageText());
        this.add(this.context().pageText(), "A rod pre-attuned to precious ores, such as {0}.\n", new Object[]{this.itemLink("diamond", (ItemLike)Items.DIAMOND_ORE)});
        return this.entry(location).withIcon((ItemLike)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, recipe});
    }
}

