/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.particle.coloredbubble;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class ColoredBubbleParticle
extends TextureSheetParticle {
    private final SpriteSet sprite;
    public float colorR;
    public float colorG;
    public float colorB;

    public ColoredBubbleParticle(ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, SpriteSet sprite) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.hasPhysics = false;
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        if ((double)this.colorR > 1.0) {
            this.colorR /= 255.0f;
        }
        if ((double)this.colorG > 1.0) {
            this.colorG /= 255.0f;
        }
        if ((double)this.colorB > 1.0) {
            this.colorB /= 255.0f;
        }
        this.setColor(this.colorR, this.colorG, this.colorB);
        this.lifetime = 10;
        this.quadSize = 0.05f;
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.sprite = sprite;
        this.pickSprite(this.sprite);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        float progress = (float)this.age / (float)this.lifetime;
        this.setAlpha(Math.lerp((float)progress, (float)1.0f, (float)0.75f));
        this.yd *= 0.75;
        this.setSpriteFromAge(this.sprite);
    }

    public boolean isAlive() {
        return this.age < this.lifetime;
    }
}

