/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.wire;

import com.klikli_dev.theurgy.content.behaviour.logistics.HasLeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.HasWireEndPoint;
import com.klikli_dev.theurgy.content.render.Color;
import com.klikli_dev.theurgy.content.render.outliner.Outliner;
import com.klikli_dev.theurgy.logistics.Logistics;
import com.klikli_dev.theurgy.logistics.Wire;
import com.klikli_dev.theurgy.logistics.WireEndPoint;
import com.klikli_dev.theurgy.logistics.Wires;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;

public class WireItem
extends Item {
    private final int maxRange;

    public WireItem(Item.Properties pProperties, int maxRange) {
        super(pProperties);
        this.maxRange = maxRange;
    }

    public static void onClientTick(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof WireItem)) {
            return;
        }
        WireEndPoint wirePoint = WireEndPoint.load(stack);
        if (wirePoint == null || wirePoint.level() != player.level().dimension()) {
            return;
        }
        Outliner.get().showAABB(wirePoint, Shapes.block().bounds().move(wirePoint.pos()), 1).colored(Color.YELLOW).lineWidth(0.03125f);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        if (!this.isWireEndPoint(pContext)) {
            if (Objects.requireNonNull(pContext.getPlayer()).isShiftKeyDown()) {
                WireEndPoint.removeFrom(stack);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        WireEndPoint wirePoint = WireEndPoint.load(stack);
        if (wirePoint != null) {
            Wire existingWire = this.getWire(pContext, wirePoint);
            if (existingWire != null) {
                return this.disconnectWire(pContext, existingWire);
            }
            return this.connectWire(pContext, wirePoint);
        }
        return this.storeWireEndPoint(pContext);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (usedHand == InteractionHand.MAIN_HAND && player.isShiftKeyDown()) {
            WireEndPoint.removeFrom(player.getMainHandItem());
            return InteractionResultHolder.sidedSuccess((Object)player.getMainHandItem(), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        WireEndPoint wirePoint = WireEndPoint.load(stack);
        if (wirePoint != null) {
            tooltipComponents.add((Component)Component.translatable((String)(stack.getDescriptionId() + ".tooltip.dynamic"), (Object[])new Object[]{Component.literal((String)("[" + wirePoint.pos().toShortString() + "]")).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GRAY));
        }
    }

    protected Wire getWire(UseOnContext pContext, WireEndPoint wireEndPoint) {
        if (wireEndPoint.level() != pContext.getLevel().dimension()) {
            return null;
        }
        return Wires.get(pContext.getLevel()).getWire(wireEndPoint.pos(), pContext.getClickedPos());
    }

    protected boolean isWireEndPoint(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        return level.getBlockState(pos).getBlock() instanceof HasWireEndPoint;
    }

    protected InteractionResult connectWire(UseOnContext pContext, WireEndPoint wireEndPoint) {
        if (wireEndPoint.level() != pContext.getLevel().dimension()) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = pContext.getClickedPos();
        if (wireEndPoint.pos().equals((Object)pos)) {
            return InteractionResult.FAIL;
        }
        if (wireEndPoint.pos().distManhattan((Vec3i)pos) > this.maxRange) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = pContext.getItemInHand();
        WireEndPoint.removeFrom(stack);
        if (!Objects.requireNonNull(pContext.getPlayer()).getAbilities().instabuild) {
            stack.shrink(1);
        }
        Level level = pContext.getLevel();
        Wires.get(level).addWire(new Wire(wireEndPoint.pos(), pos));
        if (!level.isClientSide) {
            HasLeafNodeBehaviour blockEntity;
            GlobalPos posA = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos);
            GlobalPos posB = GlobalPos.of(wireEndPoint.level(), (BlockPos)wireEndPoint.pos());
            Logistics.get().add(posA, posB);
            BlockEntity blockEntity2 = level.getBlockEntity(posA.pos());
            if (blockEntity2 instanceof HasLeafNodeBehaviour) {
                blockEntity = (HasLeafNodeBehaviour)blockEntity2;
                Logistics.get().add(blockEntity.leafNode());
            }
            if ((blockEntity2 = level.getBlockEntity(posB.pos())) instanceof HasLeafNodeBehaviour) {
                blockEntity = (HasLeafNodeBehaviour)blockEntity2;
                Logistics.get().add(blockEntity.leafNode());
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult disconnectWire(UseOnContext pContext, Wire wire) {
        ItemStack stack = pContext.getItemInHand();
        WireEndPoint.removeFrom(stack);
        if (!Objects.requireNonNull(pContext.getPlayer()).getAbilities().instabuild) {
            stack.grow(1);
        }
        Level level = pContext.getLevel();
        Wires.get(level).removeWire(wire);
        if (!level.isClientSide) {
            GlobalPos posA = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)wire.from());
            GlobalPos posB = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)wire.to());
            Logistics.get().remove(posA, posB);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult storeWireEndPoint(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        WireEndPoint wirePoint = new WireEndPoint(pContext.getClickedPos(), (ResourceKey<Level>)pContext.getLevel().dimension());
        wirePoint.save(stack);
        return InteractionResult.sidedSuccess((boolean)pContext.getLevel().isClientSide);
    }
}

