/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.sulfur;

import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeItem;
import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AlchemicalSulfurItem
extends AlchemicalDerivativeItem {
    public AlchemicalSulfurType type = AlchemicalSulfurType.MISC;

    public AlchemicalSulfurItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static AlchemicalSulfurType getType(ItemStack sulfurStack) {
        Item item = sulfurStack.getItem();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            return sulfur.type;
        }
        return AlchemicalSulfurType.MISC;
    }

    public static AlchemicalSulfurItem ofSource(TagKey<Item> source, AlchemicalDerivativeTier tier, AlchemicalSulfurType type) {
        AlchemicalSulfurItem item = new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SOURCE_TAG, source));
        item.useCustomSourceName(true);
        item.tier(tier);
        item.type(type);
        return item;
    }

    public static AlchemicalSulfurItem ofSource(Item sourceStack, AlchemicalDerivativeTier tier, AlchemicalSulfurType type) {
        return AlchemicalSulfurItem.ofSource((Holder<Item>)sourceStack.builtInRegistryHolder(), tier, type);
    }

    public static AlchemicalSulfurItem ofSource(Holder<Item> sourceStack, AlchemicalDerivativeTier tier, AlchemicalSulfurType type) {
        AlchemicalSulfurItem item = new AlchemicalSulfurItem(new Item.Properties().component(DataComponentRegistry.SOURCE_ITEM, sourceStack));
        item.tier(tier);
        item.type(type);
        return item;
    }

    @Override
    public List<MutableComponent> getTooltipData(ItemStack sulfurStack) {
        List<MutableComponent> result = super.getTooltipData(sulfurStack);
        if (this.provideAutomaticTooltipData) {
            result.add(ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)this.type().descriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true)))));
        }
        return result;
    }

    public AlchemicalSulfurItem type(AlchemicalSulfurType type) {
        this.type = type;
        return this;
    }

    public AlchemicalSulfurType type() {
        return this.type;
    }

    @Override
    public List<MutableComponent> getNameData(ItemStack stack) {
        List<MutableComponent> result = super.getNameData(stack);
        if (this.useAutomaticNameRendering) {
            result.add(ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)this.type.descriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true)))));
        }
        return result;
    }
}

