/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import com.klikli_dev.theurgy.content.gui.GuiIcons;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.gui.IconButton;
import com.klikli_dev.theurgy.content.gui.Indicator;
import com.klikli_dev.theurgy.content.item.filter.AbstractFilterScreen;
import com.klikli_dev.theurgy.content.item.filter.ListFilterMenu;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageSetListFilterScreenOption;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ListFilterScreen
extends AbstractFilterScreen<ListFilterMenu> {
    protected IconButton acceptListButton;
    protected IconButton denyListButton;
    protected IconButton respectDataComponentsButton;
    protected IconButton ignoreDataComponentsButton;
    protected Indicator acceptListIndicator;
    protected Indicator denyListIndicator;
    protected Indicator respectDataComponentsIndicator;
    protected Indicator ignoreDataComponentsIndicator;

    public ListFilterScreen(ListFilterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle, GuiTextures.FILTER);
    }

    @Override
    protected int getScreenTitleColor() {
        return 0x303030;
    }

    @Override
    protected boolean isButtonActive(IconButton button) {
        if (button == this.denyListButton) {
            return !((ListFilterMenu)this.menu).isDenyList;
        }
        if (button == this.acceptListButton) {
            return ((ListFilterMenu)this.menu).isDenyList;
        }
        if (button == this.respectDataComponentsButton) {
            return !((ListFilterMenu)this.menu).respectDataComponents;
        }
        if (button == this.ignoreDataComponentsButton) {
            return ((ListFilterMenu)this.menu).respectDataComponents;
        }
        return true;
    }

    @Override
    protected boolean isIndicatorOn(Indicator indicator) {
        if (indicator == this.denyListIndicator) {
            return ((ListFilterMenu)this.menu).isDenyList;
        }
        if (indicator == this.acceptListIndicator) {
            return !((ListFilterMenu)this.menu).isDenyList;
        }
        if (indicator == this.respectDataComponentsIndicator) {
            return ((ListFilterMenu)this.menu).respectDataComponents;
        }
        if (indicator == this.ignoreDataComponentsIndicator) {
            return !((ListFilterMenu)this.menu).respectDataComponents;
        }
        return false;
    }

    @Override
    protected List<IconButton> getButtons() {
        return Arrays.asList(this.denyListButton, this.acceptListButton, this.respectDataComponentsButton, this.ignoreDataComponentsButton);
    }

    @Override
    protected List<Indicator> getIndicators() {
        return Arrays.asList(this.denyListIndicator, this.acceptListIndicator, this.respectDataComponentsIndicator, this.ignoreDataComponentsIndicator);
    }

    @Override
    protected void init() {
        super.init();
        int x = this.leftPos;
        int y = this.topPos;
        this.denyListButton = new IconButton(x + 18, y + 75, GuiIcons.DENY_LIST);
        this.denyListButton.withTooltip("theurgy.gui.filter.deny_list_button.tooltip", "theurgy.gui.filter.deny_list_button.tooltip.shift");
        this.denyListButton.withOnClick(() -> {
            ((ListFilterMenu)this.menu).isDenyList = true;
            this.sendOptionUpdate(MessageSetListFilterScreenOption.Option.DENY_LIST);
        });
        this.addRenderableWidget((GuiEventListener)this.denyListButton);
        this.acceptListButton = new IconButton(x + 36, y + 75, GuiIcons.ACCEPT_LIST);
        this.acceptListButton.withTooltip("theurgy.gui.filter.accept_list_button.tooltip", "theurgy.gui.filter.accept_list_button.tooltip.shift");
        this.acceptListButton.withOnClick(() -> {
            ((ListFilterMenu)this.menu).isDenyList = false;
            this.sendOptionUpdate(MessageSetListFilterScreenOption.Option.ACCEPT_LIST);
        });
        this.addRenderableWidget((GuiEventListener)this.acceptListButton);
        this.denyListIndicator = new Indicator(x + 18, y + 69, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.denyListIndicator);
        this.acceptListIndicator = new Indicator(x + 36, y + 69, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.acceptListIndicator);
        this.respectDataComponentsButton = new IconButton(x + 60, y + 75, GuiIcons.RESPECT_DATA_COMPONENTS);
        this.respectDataComponentsButton.withTooltip("theurgy.gui.filter.respect_data_components_button.tooltip", "theurgy.gui.filter.respect_data_components_button.tooltip.shift");
        this.respectDataComponentsButton.withOnClick(() -> {
            ((ListFilterMenu)this.menu).respectDataComponents = true;
            this.sendOptionUpdate(MessageSetListFilterScreenOption.Option.RESPECT_DATA);
        });
        this.addRenderableWidget((GuiEventListener)this.respectDataComponentsButton);
        this.ignoreDataComponentsButton = new IconButton(x + 78, y + 75, GuiIcons.IGNORE_DATA_COMPONENTS);
        this.ignoreDataComponentsButton.withTooltip("theurgy.gui.filter.ignore_data_components_button.tooltip", "theurgy.gui.filter.ignore_data_components_button.tooltip.shift");
        this.ignoreDataComponentsButton.withOnClick(() -> {
            ((ListFilterMenu)this.menu).respectDataComponents = false;
            this.sendOptionUpdate(MessageSetListFilterScreenOption.Option.IGNORE_DATA);
        });
        this.addRenderableWidget((GuiEventListener)this.ignoreDataComponentsButton);
        this.respectDataComponentsIndicator = new Indicator(x + 60, y + 69, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.respectDataComponentsIndicator);
        this.ignoreDataComponentsIndicator = new Indicator(x + 78, y + 69, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.ignoreDataComponentsIndicator);
        this.updateIndicatorState();
    }

    protected void sendOptionUpdate(MessageSetListFilterScreenOption.Option option) {
        Networking.sendToServer(new MessageSetListFilterScreenOption(option));
    }
}

