/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.storage;

import com.klikli_dev.theurgy.util.TetraConsumer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class StorageBehaviour<S extends StorageBehaviour<?>> {
    protected BlockEntity blockEntity;
    protected TetraConsumer<IItemHandler, Integer, ItemStack, ItemStack> onContentTypeChanged;
    protected BiConsumer<IItemHandler, Integer> onContentsChanged;
    protected Consumer<IFluidHandler> onFluidContentsChanged;

    public StorageBehaviour(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    protected void onContentsChanged(IItemHandler handler, int slot) {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.accept(handler, slot);
        }
    }

    protected void onContentTypeChanged(IItemHandler handler, int slot, ItemStack oldStack, ItemStack newStack) {
        if (this.onContentTypeChanged != null) {
            this.onContentTypeChanged.accept(handler, slot, oldStack, newStack);
        }
    }

    protected void onFluidContentsChanged(IFluidHandler handler) {
        if (this.onFluidContentsChanged != null) {
            this.onFluidContentsChanged.accept(handler);
        }
    }

    public S withOnContentTypeChanged(TetraConsumer<IItemHandler, Integer, ItemStack, ItemStack> onContentTypeChanged) {
        this.onContentTypeChanged = onContentTypeChanged;
        return (S)this;
    }

    public S withOnContentsChanged(BiConsumer<IItemHandler, Integer> onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
        return (S)this;
    }

    public S onFluidContentsChanged(Consumer<IFluidHandler> onFluidContentsChanged) {
        this.onFluidContentsChanged = onFluidContentsChanged;
        return (S)this;
    }

    public abstract void readNetwork(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void writeNetwork(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void saveAdditional(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void loadAdditional(CompoundTag var1, HolderLookup.Provider var2);

    protected void sendBlockUpdated() {
        if (this.blockEntity.getLevel() != null && !this.blockEntity.getLevel().isClientSide) {
            this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 2);
        }
    }

    protected void setChanged() {
        this.blockEntity.setChanged();
    }
}

