/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.network;

import com.github.bigenergy.glassential.items.GlassPainterItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GlassPainterPacket(int color, boolean emitLight, boolean emitRedstone, boolean passPlayer, boolean passEntity) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GlassPainterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"glassential", (String)"glass_painter"));
    public static final StreamCodec<ByteBuf, GlassPainterPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeInt(packet.color);
        buf.writeBoolean(packet.emitLight);
        buf.writeBoolean(packet.emitRedstone);
        buf.writeBoolean(packet.passPlayer);
        buf.writeBoolean(packet.passEntity);
    }, buf -> new GlassPainterPacket(buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean()));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GlassPainterPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() instanceof GlassPainterItem) {
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                tag.putInt("Color", packet.color);
                tag.putBoolean("EmitLight", packet.emitLight);
                tag.putBoolean("EmitRedstone", packet.emitRedstone);
                tag.putBoolean("PassPlayer", packet.passPlayer);
                tag.putBoolean("PassEntity", packet.passEntity);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            } else {
                stack = player.getOffhandItem();
                if (stack.getItem() instanceof GlassPainterItem) {
                    CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    tag.putInt("Color", packet.color);
                    tag.putBoolean("EmitLight", packet.emitLight);
                    tag.putBoolean("EmitRedstone", packet.emitRedstone);
                    tag.putBoolean("PassPlayer", packet.passPlayer);
                    tag.putBoolean("PassEntity", packet.passEntity);
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                }
            }
        });
    }
}

