/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.mixin;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel"})
public class ConnectingBakedModelMixin {
    private static Field tintIndexField;

    @Inject(method={"getQuads"}, at={@At(value="RETURN")}, cancellable=false, remap=false)
    private void injectTintIndex(BlockState state, Direction direction, RandomSource random, ModelData modelData, RenderType renderType, CallbackInfoReturnable<List<BakedQuad>> cir) {
        if (state != null) {
            try {
                String blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
                if ((blockId.equals("glassential:colorable_glass") || blockId.equals("glassential:colorable_stained_glass")) && tintIndexField != null) {
                    List originalQuads = (List)cir.getReturnValue();
                    for (BakedQuad quad : originalQuads) {
                        try {
                            tintIndexField.setInt(quad, 0);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        try {
            tintIndexField = BakedQuad.class.getDeclaredField("tintIndex");
            tintIndexField.setAccessible(true);
        }
        catch (Exception e) {
            System.err.println("Failed to get tintIndex field: " + String.valueOf(e));
        }
    }
}

