/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.client;

import com.github.bigenergy.glassential.blocks.entity.ColorableGlassBlockEntity;
import com.github.bigenergy.glassential.blocks.entity.OneWayGlassBlockEntity;
import com.github.bigenergy.glassential.client.model.OneWayModelGeometry;
import com.github.bigenergy.glassential.init.GlassentialBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

@EventBusSubscriber(modid="glassential", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GlassentialBlocks.ONE_WAY_GLASS.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GlassentialBlocks.CLEAR_FLUID_GLASS.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GlassentialBlocks.COLORABLE_GLASS.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GlassentialBlocks.COLORABLE_STAINED_GLASS.get()), (RenderType)RenderType.translucent());
            BlockColors bc = Minecraft.getInstance().getBlockColors();
            ThreadLocal<Boolean> REENTRANT = ThreadLocal.withInitial(() -> false);
            bc.register((state, level, pos, tintIndex) -> {
                if (level == null || pos == null) {
                    return -1;
                }
                if (Boolean.TRUE.equals(REENTRANT.get())) {
                    return -1;
                }
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof OneWayGlassBlockEntity) {
                    OneWayGlassBlockEntity ow = (OneWayGlassBlockEntity)be;
                    BlockState mimic = ow.getMimic();
                    if (mimic == null || mimic.isAir()) {
                        return -1;
                    }
                    if (mimic.getBlock() == state.getBlock()) {
                        return -1;
                    }
                    try {
                        REENTRANT.set(true);
                        int n = bc.getColor(mimic, level, pos, tintIndex);
                        return n;
                    }
                    finally {
                        REENTRANT.set(false);
                    }
                }
                return -1;
            }, new Block[]{(Block)GlassentialBlocks.ONE_WAY_GLASS.get()});
            bc.register((state, level, pos, tintIndex) -> {
                if (level == null || pos == null) {
                    return 0xFFFFFF;
                }
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof ColorableGlassBlockEntity) {
                    ColorableGlassBlockEntity colorable = (ColorableGlassBlockEntity)be;
                    return colorable.getColor();
                }
                return 0xFFFFFF;
            }, new Block[]{(Block)GlassentialBlocks.COLORABLE_GLASS.get()});
            bc.register((state, level, pos, tintIndex) -> {
                if (level == null || pos == null) {
                    return 0xFFFFFF;
                }
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof ColorableGlassBlockEntity) {
                    ColorableGlassBlockEntity colorable = (ColorableGlassBlockEntity)be;
                    return colorable.getColor();
                }
                return 0xFFFFFF;
            }, new Block[]{(Block)GlassentialBlocks.COLORABLE_STAINED_GLASS.get()});
        });
    }

    @SubscribeEvent
    public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders e) {
        e.register(ResourceLocation.fromNamespaceAndPath((String)"glassential", (String)"one_way_loader"), (IGeometryLoader)new OneWayModelGeometry.Loader());
    }
}

