/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.blocks;

import com.github.bigenergy.glassential.blocks.entity.ColorableGlassBlockEntity;
import com.github.bigenergy.glassential.init.GlassentialBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorableGlassBlock
extends BaseEntityBlock {
    public static final MapCodec<ColorableGlassBlock> CODEC = ColorableGlassBlock.simpleCodec(ColorableGlassBlock::new);
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");

    public ColorableGlassBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 15 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT});
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.glassential.colorable").withStyle(ChatFormatting.GRAY));
    }

    public float getShadeBrightness(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        ColorableGlassBlockEntity colorable;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof ColorableGlassBlockEntity && (colorable = (ColorableGlassBlockEntity)be).getEmitLight()) {
            return 15;
        }
        return super.getLightEmission(state, level, pos);
    }

    public int getLightBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        ColorableGlassBlockEntity colorable;
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof ColorableGlassBlockEntity && (colorable = (ColorableGlassBlockEntity)be).getEmitRedstone()) {
            return 15;
        }
        return 0;
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pLevel instanceof Level) {
            Level level = (Level)pLevel;
            level.updateNeighborsAt(pPos, (Block)this);
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)LIT) == false;
    }

    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pAdjacentBlockState.is((Block)this) || super.skipRendering(pState, pAdjacentBlockState, pDirection);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof ColorableGlassBlockEntity) {
            EntityCollisionContext entityContext;
            Entity entity;
            ColorableGlassBlockEntity colorable = (ColorableGlassBlockEntity)be;
            if (colorable.getPassPlayer() && pContext instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)pContext).getEntity()) instanceof Player) {
                return Shapes.empty();
            }
            if (colorable.getPassEntity()) {
                return Shapes.empty();
            }
        }
        return super.getCollisionShape(pState, pLevel, pPos, pContext);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)GlassentialBlockEntities.COLORABLE_GLASS.get()).create(pPos, pState);
    }
}

