/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential;

import com.github.bigenergy.glassential.Config;
import com.github.bigenergy.glassential.datagen.GlassentialBlockLoot;
import com.github.bigenergy.glassential.datagen.GlassentialBlockTag;
import com.github.bigenergy.glassential.datagen.GlassentialFluid;
import com.github.bigenergy.glassential.datagen.GlassentialItemTag;
import com.github.bigenergy.glassential.init.GlassentialBlockEntities;
import com.github.bigenergy.glassential.init.GlassentialBlocks;
import com.github.bigenergy.glassential.network.GlassPainterPacket;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="glassential")
public class Glassential {
    public static final String MODID = "glassential";
    public static final Logger LOGGER = LogManager.getLogger((String)"Glassential Renewed");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"glassential");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GLASSENTIAL_TAB = CREATIVE_MODE_TABS.register("glassential_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.glassential")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> new ItemStack((ItemLike)GlassentialBlocks.GLASS_DARK_ETHEREAL.get())).displayItems((parameters, output) -> {
        GlassentialBlocks.ITEMS_FOR_TAB_LIST_FUNC.forEach(registryObject -> output.accept(new ItemStack((ItemLike)registryObject.get())));
        output.accept(new ItemStack((ItemLike)GlassentialBlocks.GLASS_PAINTER.get()));
    }).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GLASSENTIAL_TAB_FUNCTIONALITY = CREATIVE_MODE_TABS.register("glassential_tab_misc", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.glassential_misc")).withTabsBefore(new ResourceLocation[]{GLASSENTIAL_TAB.getId()}).icon(() -> new ItemStack((ItemLike)GlassentialBlocks.STONE_GLASS.get())).displayItems((parameters, output) -> GlassentialBlocks.ITEMS_FOR_TAB_LIST.forEach(registryObject -> output.accept(new ItemStack((ItemLike)registryObject.get())))).build());

    public Glassential(IEventBus modEventBus, ModContainer modContainer) {
        GlassentialBlocks.BLOCKS.register(modEventBus);
        GlassentialBlocks.ITEMS.register(modEventBus);
        GlassentialBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::registerPackets);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::gatherData);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(GlassPainterPacket.TYPE, GlassPainterPacket.STREAM_CODEC, GlassPainterPacket::handle);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Starting Glassential Renewed");
    }

    private void gatherData(GatherDataEvent e) {
        DataGenerator gen = e.getGenerator();
        PackOutput out = gen.getPackOutput();
        ExistingFileHelper helper = e.getExistingFileHelper();
        CompletableFuture lookup = e.getLookupProvider();
        gen.addProvider(e.includeServer(), (DataProvider)new LootTableProvider(out, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GlassentialBlockLoot::new, LootContextParamSets.BLOCK)), lookup));
        GlassentialBlockTag blockTags = (GlassentialBlockTag)gen.addProvider(e.includeServer(), (DataProvider)new GlassentialBlockTag(out, lookup, helper));
        gen.addProvider(e.includeServer(), (DataProvider)new GlassentialItemTag(out, lookup, blockTags.contentsGetter(), helper));
        gen.addProvider(e.includeServer(), (DataProvider)new GlassentialFluid(out, lookup, helper));
    }
}

